# 配色方案库 - 100+ 专业调色板

按场景分类的配色方案，包含 Tailwind CSS 类名和十六进制色值。

---

## 🔵 科技/商务系列

### Tech Blue（科技蓝）
```css
/* 主色调 */
primary-50:  #eff6ff  /* blue-50 */
primary-100: #dbeafe  /* blue-100 */
primary-200: #bfdbfe  /* blue-200 */
primary-300: #93c5fd  /* blue-300 */
primary-400: #60a5fa  /* blue-400 */
primary-500: #3b82f6  /* blue-500 */
primary-600: #2563eb  /* blue-600 - 主色 */
primary-700: #1d4ed8  /* blue-700 */
primary-800: #1e40af  /* blue-800 */
primary-900: #1e3a8a  /* blue-900 */

/* 中性色 */
gray-50:  #f8fafc
gray-100: #f1f5f9
gray-200: #e2e8f0
gray-300: #cbd5e1
gray-400: #94a3b8
gray-500: #64748b
gray-600: #475569
gray-700: #334155
gray-800: #1e293b
gray-900: #0f172a

/* 语义色 */
success: #10b981  /* emerald-500 */
warning: #f59e0b  /* amber-500 */
error:   #ef4444  /* red-500 */
info:    #06b6d4  /* cyan-500 */
```
**适用：** SaaS、企业应用、开发者工具

---

### Indigo Night（靛蓝之夜）
```css
primary:   #4f46e5  /* indigo-600 */
secondary: #818cf8  /* indigo-400 */
accent:    #f59e0b  /* amber-500 */
background:#f8fafc
surface:   #ffffff
text:      #1e293b
muted:     #64748b
```
**适用：** 金融科技、数据分析、B2B平台

---

### Ocean Breeze（海洋微风）
```css
primary:   #0891b2  /* cyan-600 */
secondary: #22d3ee  /* cyan-400 */
accent:    #0ea5e9  /* sky-500 */
background:#ecfeff
surface:   #ffffff
text:      #164e63
muted:     #0e7490
```
**适用：** 健康应用、生活类App、清新品牌

---

## 🟢 自然/健康系列

### Forest Sage（森林鼠尾草）
```css
primary:   #059669  /* emerald-600 */
secondary: #34d399  /* emerald-400 */
accent:    #fbbf24  /* amber-400 */
background:#f0fdf4
surface:   #ffffff
text:      #064e3b
muted:     #047857

/* 扩展色 */
leaf:      #65a30d  /* lime-600 */
earth:     #92400e  /* amber-800 */
sand:      #fef3c7  /* amber-100 */
```
**适用：** 有机食品、健康医疗、环保品牌

---

### Mint Fresh（薄荷清新）
```css
primary:   #14b8a6  /* teal-500 */
secondary: #5eead4  /* teal-300 */
accent:    #f97316  /* orange-500 */
background:#f0fdfa
surface:   #ffffff
text:      #134e4a
muted:     #0d9488
```
**适用：** 个人护理、口腔护理、清洁产品

---

### Wellness Sand（康养沙色）
```css
primary:   #78716c  /* stone-500 */
secondary: #a8a29e  /* stone-400 */
accent:    #14b8a6  /* teal-500 */
background:#fafaf9
surface:   #ffffff
text:      #44403c
muted:     #a8a29e

/* 自然色系 */
sage:      #84a98c
clay:      #d4a373
linen:     #faedcd
cream:     #fefae0
```
**适用：** 瑜伽、冥想、Spa、生活方式

---

## 🟣 创意/时尚系列

### Purple Haze（紫雾迷情）
```css
primary:   #7c3aed  /* violet-600 */
secondary: #a78bfa  /* violet-400 */
accent:    #ec4899  /* pink-500 */
background:#f5f3ff
surface:   #ffffff
text:      #2e1065
muted:     #6d28d9
```
**适用：** 创意机构、时尚品牌、美妆产品

---

### Sunset Gradient（日落渐变）
```css
/* 渐变主色 */
gradient-start: #f97316  /* orange-500 */
gradient-mid:   #db2777  /* pink-600 */
gradient-end:   #7c3aed  /* violet-600 */

/* 辅助色 */
background: #fff7ed
surface:    #ffffff
text:       #431407
muted:      #9a3412
```
**适用：** 社交媒体、年轻品牌、娱乐应用

---

### Cyber Purple（赛博紫）
```css
primary:   #a855f7  /* purple-500 */
secondary: #22d3ee  /* cyan-400 */
accent:    #fbbf24  /* amber-400 */
background:#0f0720
surface:   #1e1b4b
text:      #faf5ff
muted:     #a855f7
```
**适用：** 游戏、科技、夜生活应用

---

## 🔴 食品/餐饮系列

### Tomato Fresh（番茄红）
```css
primary:   #dc2626  /* red-600 */
secondary: #f87171  /* red-400 */
accent:    #16a34a  /* green-600 */
background:#fef2f2
surface:   #ffffff
text:      #7f1d1d
muted:     #dc2626

/* 食品色系 */
cheese:    #fbbf24
lettuce:   #22c55e
meat:      #7f1d1d
```
**适用：** 餐饮、外卖、食品包装

---

### Coffee Roast（咖啡烘焙）
```css
primary:   #78350f  /* amber-900 */
secondary: #b45309  /* amber-700 */
accent:    #10b981  /* emerald-500 */
background:#fffbeb
surface:   #ffffff
text:      #451a03
muted:     #92400e

/* 咖啡色系 */
espresso:  #292524  /* stone-800 */
latte:     #d6d3d1  /* stone-300 */
cream:     #fafaf9  /* stone-50 */
```
**适用：** 咖啡品牌、烘焙店、手工食品

---

### Berry Smoothie（莓果冰沙）
```css
primary:   #db2777  /* pink-600 */
secondary: #f472b6  /* pink-400 */
accent:    #84cc16  /* lime-500 */
background:#fdf2f8
surface:   #ffffff
text:      #831843
muted:     #db2777
```
**适用：** 饮品店、甜品、健康轻食

---

## 🟡 金融/法律系列

### Gold Standard（黄金标准）
```css
primary:   #1e3a8a  /* blue-900 */
secondary: #64748b  /* slate-500 */
accent:    #d97706  /* amber-600 */
background:#f8fafc
surface:   #ffffff
text:      #0f172a
muted:     #64748b

/* 金融色系 */
gold:      #fbbf24
platinum:  #e2e8f0
wealth:    #15803d
```
**适用：** 银行、投资、保险、高端服务

---

### Law Firm Classic（律所经典）
```css
primary:   #1e293b  /* slate-800 */
secondary: #475569  /* slate-600 */
accent:    #991b1b  /* red-800 */
background:#f1f5f9
surface:   #ffffff
text:      #020617
muted:     #64748b
```
**适用：** 律师事务所、会计事务所、咨询

---

## ⚫ 暗黑模式系列

### Midnight Dark（午夜黑）
```css
background: #030712  /* gray-950 */
surface:    #111827  /* gray-900 */
primary:    #3b82f6  /* blue-500 */
secondary:  #60a5fa  /* blue-400 */
accent:     #22d3ee  /* cyan-400 */
text:       #f9fafb  /* gray-50 */
muted:      #6b7280  /* gray-500 */
border:     #374151  /* gray-700 */
```
**适用：** 开发者工具、媒体应用、游戏

---

### Deep Ocean（深海）
```css
background: #0c4a6e  /* sky-900 */
surface:    #075985  /* sky-800 */
primary:    #38bdf8  /* sky-400 */
secondary:  #7dd3fc  /* sky-300 */
accent:     #f472b6  /* pink-400 */
text:       #f0f9ff  /* sky-50 */
muted:      #7dd3fc  /* sky-300 */
```
**适用：** 海洋主题、科技感、沉浸体验

---

### Obsidian（黑曜石）
```css
background: #09090b  /* zinc-950 */
surface:    #18181b  /* zinc-900 */
primary:    #a855f7  /* purple-500 */
secondary:  #c084fc  /* purple-400 */
accent:     #22c55e  /* green-500 */
text:       #fafafa  /* zinc-50 */
muted:      #71717a  /* zinc-500 */
```
**适用：** 高端产品、神秘品牌、游戏

---

## 🎨 特殊场景配色

### Accessibility High Contrast（高对比无障碍）
```css
/* WCAG AAA 标准 */
background: #ffffff
text:       #000000
primary:    #005fcc
success:    #008000
warning:    #ff8c00
error:      #d90000
```
**适用：** 政府网站、无障碍要求严格的应用

---

### Kids Playful（儿童活泼）
```css
primary:   #f59e0b  /* amber-500 */
secondary: #ec4899  /* pink-500 */
tertiary:  #8b5cf6  /* violet-500 */
quaternary:#10b981  /* emerald-500 */
background:#fffbeb
surface:   #ffffff
text:      #451a03
```
**适用：** 儿童应用、教育游戏、玩具品牌

---

### Monochrome Elegant（单色优雅）
```css
/* 只用灰度 */
black:     #000000
dark:      #171717
gray-800:  #262626
gray-700:  #404040
gray-600:  #525252
gray-500:  #737373
gray-400:  #a3a3a3
gray-300:  #d4d4d4
gray-200:  #e5e5e5
gray-100:  #f5f5f5
white:     #ffffff

/* 唯一强调色 */
accent:    #dc2626  /* 红 */
```
**适用：** 时尚杂志、摄影集、高端品牌

---

## 💡 配色使用技巧

### 60-30-10 法则
```
60% - 主背景色（中性色）
30% - 次要色（主品牌色）
10% - 强调色（CTA、高亮）
```

### 深色模式配色技巧
1. 避免纯黑（#000），用深灰（#0f172a, #111827）
2. 降低饱和度（使用 400/500 而非 600/700）
3. 提高对比度但不刺眼
4. 使用色彩层级区分重要性

### 色彩心理学速查
| 颜色 | 情感联想 | 适用行业 |
|-----|---------|---------|
| 蓝 | 信任、专业 | 科技、金融、医疗 |
| 绿 | 自然、健康 | 环保、有机、健康 |
| 红 | 热情、紧急 | 食品、促销、警示 |
| 紫 | 奢华、创意 | 美妆、艺术、奢侈品 |
| 橙 | 活力、友好 | 娱乐、餐饮、年轻品牌 |
| 黑 | 高端、神秘 | 奢侈品、科技、夜生活 |

---

**工具推荐：**
- Coolors.co - 生成配色方案
- Huevy.app - 色彩调色
- WebAIM Contrast Checker - 对比度检查
