# 图表类型指南 - 数据可视化参考

什么时候用什么图表，以及如何用 Tailwind CSS 实现专业效果。

---

## 📊 比较类图表

### 柱状图（Bar Chart）
**用途：** 比较不同类别的数值大小

**适合场景：**
- 销售额对比
- 用户数量对比
- 各渠道流量
- 成绩/分数对比

**设计要点：**
```
✅ 类别少于 12 个
✅ 从 0 开始 Y 轴
✅ 使用一致的颜色
✅ 添加数值标签
❌ 避免 3D 效果
```

**Tailwind 风格：**
```html
<div class="flex items-end gap-2 h-64">
  <div class="w-12 bg-blue-500 rounded-t" style="height: 60%"></div>
  <div class="w-12 bg-blue-500 rounded-t" style="height: 80%"></div>
  <div class="w-12 bg-blue-500 rounded-t" style="height: 45%"></div>
</div>
```

---

### 分组柱状图（Grouped Bar）
**用途：** 比较多个维度在同一类别下的数值

**适合场景：**
- 不同年份各季度对比
- 多产品各渠道销售
- 男女比例对比

---

### 堆叠柱状图（Stacked Bar）
**用途：** 显示整体和部分的关系，同时比较整体大小

**适合场景：**
- 收入构成分析
- 用户来源分布
- 预算分配

---

## 📈 趋势类图表

### 折线图（Line Chart）
**用途：** 显示数据随时间的变化趋势

**适合场景：**
- 股价走势
- 网站流量趋势
- 气温变化
- 用户增长曲线

**设计要点：**
```
✅ 时间轴从左到右
✅ 多条线用不同颜色
✅ 关键节点添加标记
✅ 平滑曲线或直线视场景而定
❌ 类别过多（最多 4-5 条线）
```

**Tailwind 实现思路：**
```html
<svg class="w-full h-64" viewBox="0 0 400 200">
  <!-- 网格线 -->
  <line x1="0" y1="50" x2="400" y2="50" class="stroke-gray-200" />
  <!-- 数据线 -->
  <path d="M0,150 Q100,100 200,80 T400,50" 
        fill="none" 
        stroke="currentColor" 
        class="text-blue-500 stroke-2" />
  <!-- 数据点 -->
  <circle cx="200" cy="80" r="4" class="fill-blue-500" />
</svg>
```

---

### 面积图（Area Chart）
**用途：** 强调数量随时间的累积变化

**适合场景：**
- 累计用户增长
- 市场份额变化
- 收入累积

---

###  sparkline（迷你图）
**用途：** 在表格或卡片中显示趋势

**适合场景：**
- 股票列表
- KPI 卡片
- 表格内嵌趋势

---

## 🥧 占比类图表

### 饼图（Pie Chart）
**用途：** 显示各部分占整体的比例

**适合场景：**
- 市场份额
- 预算分配
- 用户构成

**设计要点：**
```
✅ 类别 2-6 个
✅ 按大小排序（顺时针）
✅ 百分比标签清晰
✅ 使用协调的配色
❌ 类别过多
❌ 大小差异太小
```

---

### 环形图（Donut Chart）
**用途：** 饼图的变体，中间可显示总计

**优势：**
- 中间可放总数
- 可同时显示多个环
- 更现代的外观

**Tailwind 风格：**
```html
<div class="relative w-48 h-48">
  <svg class="w-full h-full transform -rotate-90">
    <circle cx="96" cy="96" r="80" 
            fill="none" 
            stroke="#e2e8f0" 
            stroke-width="20" />
    <circle cx="96" cy="96" r="80" 
            fill="none" 
            stroke="#3b82f6" 
            stroke-width="20"
            stroke-dasharray="251 377"
            class="transition-all" />
  </svg>
  <div class="absolute inset-0 flex items-center justify-center">
    <span class="text-2xl font-bold">67%</span>
  </div>
</div>
```

---

### 堆叠面积图（100% Stacked Area）
**用途：** 显示各部分占比随时间的变化

**适合场景：**
- 市场份额变化趋势
- 用户构成变化

---

## 🎯 分布类图表

### 散点图（Scatter Plot）
**用途：** 显示两个变量之间的关系

**适合场景：**
- 身高体重关系
- 广告投入 vs 销售额
- 温度 vs 冰淇淋销量

**设计要点：**
```
✅ 添加趋势线
✅ 悬停显示详情
✅ 处理重叠点
✅ 坐标轴标签清晰
```

---

### 气泡图（Bubble Chart）
**用途：** 散点图的扩展，增加第三个维度（大小）

**适合场景：**
- 国家数据（GDP, 人口, 寿命）
- 产品分析（价格, 销量, 利润率）

---

### 直方图（Histogram）
**用途：** 显示数据分布频率

**适合场景：**
- 年龄分布
- 成绩分布
- 收入分布

**与柱状图区别：**
- 直方图：连续数据，柱子相连
- 柱状图：离散类别，柱子分离

---

## 🗺️ 地理类图表

### 地图（Choropleth Map）
**用途：** 在地理区域上显示数据

**适合场景：**
- 全国销售分布
- 全球用户分布
- 各州选举结果

**设计要点：**
```
✅ 使用渐变色表示数值
✅ 提供图例
✅ 支持缩放/平移
✅ 点击显示详情
```

---

### 热力图（Heatmap）
**用途：** 用颜色密度显示数据强度

**适合场景：**
- 网站点击热力图
- 时间序列热力图（日历）
- 相关性矩阵

---

## 📋 其他专用图表

### 漏斗图（Funnel Chart）
**用途：** 显示流程中各阶段的转化率

**适合场景：**
- 销售漏斗
- 招聘流程
- 用户注册转化

---

### 仪表盘（Gauge Chart）
**用途：** 显示单一数值在范围内的位置

**适合场景：**
- KPI 完成度
- 满意度评分
- 系统状态

---

### 甘特图（Gantt Chart）
**用途：** 显示项目时间线

**适合场景：**
- 项目管理
- 排期计划
- 任务依赖

---

### 词云（Word Cloud）
**用途：** 显示文本数据中词频

**适合场景：**
- 用户反馈分析
- 标签展示
- 情感分析

---

### 树状图（Treemap）
**用途：** 用嵌套矩形显示层级数据

**适合场景：**
- 文件系统大小
- 预算层级
- 市场份额层级

---

## 🎨 图表设计系统

### 配色方案

**单色系（单变量）：**
```css
chart-100: #dbeafe
chart-200: #93c5fd
chart-300: #3b82f6
chart-400: #2563eb
```

**分类色（多变量）：**
```css
category-1: #3b82f6  /* 蓝 */
category-2: #10b981  /* 绿 */
category-3: #f59e0b  /* 黄 */
category-4: #ef4444  /* 红 */
category-5: #8b5cf6  /* 紫 */
category-6: #ec4899  /* 粉 */
```

**语义色：**
```css
positive: #10b981  /* 增长/良好 */
negative: #ef4444  /* 下降/警告 */
neutral:  #6b7280  /* 持平/中性 */
```

---

### 尺寸规范

```
小型图表（卡片内）: 200-300px 宽
中型图表（侧边栏）: 400-600px 宽
大型图表（全宽）:   100% 容器宽
图表高度:           宽度 × 0.6 (黄金比例)
```

---

### 响应式处理

```html
<div class="w-full overflow-x-auto">
  <div class="min-w-[600px]">
    <!-- 图表内容 -->
  </div>
</div>
```

---

## 📱 图表选择决策树

```
你要展示什么？
│
├── 比较数值 → 柱状图
│   ├── 多个类别 → 分组柱状图
│   └── 部分整体 → 堆叠柱状图
│
├── 显示趋势 → 折线图
│   ├── 强调总量 → 面积图
│   └── 小空间 → Sparkline
│
├── 显示占比 → 饼图/环形图
│   └── 时间变化 → 堆叠面积图
│
├── 显示关系 → 散点图
│   └── 三个变量 → 气泡图
│
├── 显示分布 → 直方图/箱线图
│
└── 地理数据 → 地图/热力图
```

---

## 🛠️ 推荐工具

| 工具 | 类型 | 适用场景 |
|-----|-----|---------|
| Chart.js | 开源库 | 快速实现标准图表 |
| D3.js | 开源库 | 自定义复杂可视化 |
| Recharts | React | React 项目 |
| ECharts | 开源库 | 中文场景、大数据 |
| Highcharts | 商业 | 企业级应用 |

---

## 💡 设计原则

1. **选择合适的图表类型** - 不要为了好看而用复杂图表
2. **保持简洁** - 删除不必要的网格线、装饰
3. **颜色有意义** - 使用颜色传达信息，不只是装饰
4. **添加标签** - 图表必须能独立理解
5. **响应式设计** - 移动端体验同样重要
6. **可访问性** - 考虑色盲用户，提供替代文本

---

**记住：** 最好的图表是让人一眼就能看懂数据的图表。
