# UI UX Pro Max

**English** | [中文](#中文说明)

A comprehensive UI/UX design resource library for creating professional, beautiful user interfaces.

## 🎯 Overview

UI UX Pro Max is a curated collection of design resources that helps AI assistants generate professional-grade interfaces. It includes 50+ UI styles, 100+ color palettes, typography pairings, chart guidelines, UX patterns, and component specifications - all with Tailwind CSS code examples.

## 📦 What's Included

| Resource | File | Contents |
|----------|------|----------|
| 🎨 **UI Styles** | `references/ui-styles.md` | 50+ design styles (Minimalist, Glassmorphism, Brutalist, etc.) |
| 🌈 **Color Palettes** | `references/color-palettes.md` | 100+ professional color schemes with Tailwind classes |
| 🔤 **Typography** | `references/typography.md` | 20+ font pairings from Google Fonts |
| 📊 **Charts** | `references/charts.md` | Data visualization guide with when-to-use recommendations |
| 📘 **UX Patterns** | `references/ux-patterns.md` | Best practices for navigation, forms, feedback, etc. |
| 🎯 **Components** | `references/components.md` | Design system for buttons, inputs, cards, alerts, etc. |

## 🚀 Quick Start

When you need to design a UI, tell your AI assistant:

```
"Use ui-ux-pro-max skill to design a SaaS landing page with Minimalist style, 
Tech Blue color palette, and Inter font family"
```

The AI will automatically load relevant resources and generate professional designs.

## 💡 Usage Examples

### Design Style Selection
> "Design a dashboard using Glassmorphism style with dark mode"

### Color Palette
> "Use Indigo Night color scheme with amber accent"

### Typography
> "Heading with Space Grotesk, body with Inter"

### Chart Selection
> "Show monthly sales trend with area chart"

## 🎨 Design Categories

### UI Styles Include:
- **Modern Minimal**: Minimalist, Clean Tech, Corporate Modern
- **Creative Bold**: Brutalist, Maximalist, Y2K Revival
- **Skeuomorphic**: Neumorphism, Glassmorphism, Claymorphism
- **Industry-Specific**: Fintech, Health, E-commerce, EdTech
- **Artistic**: Editorial, Swiss Style, Japanese Minimal
- **Dark Mode**: Premium Dark, Cyberpunk, Dark Academia

### Color Palettes Include:
- **Tech/Business**: Tech Blue, Indigo Night, Ocean Breeze
- **Nature/Health**: Forest Sage, Mint Fresh, Wellness Sand
- **Creative/Fashion**: Purple Haze, Sunset Gradient, Cyber Purple
- **Food/Dining**: Tomato Fresh, Coffee Roast, Berry Smoothie
- **Finance/Legal**: Gold Standard, Law Firm Classic
- **Dark Mode**: Midnight Dark, Deep Ocean, Obsidian

## 🛠️ Technical Details

- **Framework**: Tailwind CSS
- **Font Source**: Google Fonts
- **Icons**: SVG/Inline (no dependencies)
- **License**: MIT

## 📄 File Structure

```
ui-ux-pro-max/
├── SKILL.md                      # Main entry point
├── README.md                     # Documentation (this file)
├── references/
│   ├── ui-styles.md              # 50+ design styles
│   ├── color-palettes.md         # 100+ color schemes
│   ├── typography.md             # 20+ font pairings
│   ├── charts.md                 # Chart type guide
│   ├── ux-patterns.md            # UX best practices
│   └── components.md             # Component specs
└── LICENSE                       # MIT License
```

## 🤝 Acknowledgments

This skill aggregates industry-standard design knowledge and best practices. Design principles, color theory, and UX patterns are publicly available knowledge in the design community.

Inspired by modern design resources and tools used by professional designers worldwide.

## 📜 License

MIT License - feel free to use, modify, and distribute.

---

# 中文说明

**中文** | [English](#ui-ux-pro-max)

一个全面的 UI/UX 设计资源库，用于创建专业、精美的用户界面。

## 🎯 简介

UI UX Pro Max 是一个精心整理的设计资源合集，帮助 AI 助手生成专业级界面。包含 50+ UI 风格、100+ 配色方案、字体配对、图表指南、UX 模式和组件规范——全部带有 Tailwind CSS 代码示例。

## 📦 包含内容

| 资源 | 文件 | 内容 |
|-----|------|------|
| 🎨 **UI 风格库** | `references/ui-styles.md` | 50+ 种设计风格 |
| 🌈 **配色方案** | `references/color-palettes.md` | 100+ 专业调色板 |
| 🔤 **字体配对** | `references/typography.md` | 20+ 字体组合 |
| 📊 **图表类型** | `references/charts.md` | 数据可视化指南 |
| 📘 **UX 模式** | `references/ux-patterns.md` | 最佳实践 |
| 🎯 **组件规范** | `references/components.md` | 组件设计系统 |

## 🚀 快速开始

当你需要设计 UI 时，告诉 AI 助手：

```
"使用 ui-ux-pro-max skill 帮我设计一个 SaaS 着陆页，
使用 Minimalist 风格、Tech Blue 配色、Inter 字体"
```

AI 会自动加载相关资源，生成专业的设计方案。

## 💡 使用示例

### 选择设计风格
> "用 Glassmorphism 风格设计一个暗黑模式仪表盘"

### 选择配色
> "使用 Indigo Night 配色，琥珀色作为强调色"

### 选择字体
> "标题用 Space Grotesk，正文用 Inter"

### 选择图表
> "用面积图展示月度销售趋势"

## 🎨 设计分类

### UI 风格包括：
- **现代极简**：极简主义、清爽科技、现代企业
- **创意大胆**：粗野主义、极繁主义、千禧复古
- **拟物化**：新拟态、玻璃拟态、粘土拟态
- **行业专属**：金融科技、健康医疗、电商、教育
- **艺术风格**：编辑/杂志、瑞士风格、日式极简
- **暗黑模式**：高级暗黑、赛博朋克、暗黑学院

### 配色方案包括：
- **科技/商务**：科技蓝、靛蓝之夜、海洋微风
- **自然/健康**：森林鼠尾草、薄荷清新、康养沙色
- **创意/时尚**：紫雾迷情、日落渐变、赛博紫
- **食品/餐饮**：番茄红、咖啡烘焙、莓果冰沙
- **金融/法律**：黄金标准、律所经典
- **暗黑模式**：午夜黑、深海、黑曜石

## 🛠️ 技术细节

- **框架**：Tailwind CSS
- **字体来源**：Google Fonts
- **图标**：SVG/内联（无依赖）
- **许可证**：MIT

## 📄 文件结构

```
ui-ux-pro-max/
├── SKILL.md                      # 主入口文档
├── README.md                     # 文档（本文件）
├── references/
│   ├── ui-styles.md              # 50+ 设计风格
│   ├── color-palettes.md         # 100+ 配色方案
│   ├── typography.md             # 20+ 字体配对
│   ├── charts.md                 # 图表类型指南
│   ├── ux-patterns.md            # UX 最佳实践
│   └── components.md             # 组件设计规范
└── LICENSE                       # MIT 许可证
```

## 🤝 致谢

本 skill 整合了行业标准的设计知识和最佳实践。设计原则、色彩理论和 UX 模式是设计界公开可用的知识。

灵感来源于全球专业设计师使用的现代设计资源和工具。

## 📜 许可证

MIT 许可证 - 可自由使用、修改和分发。

---

**Version**: 1.0.0  
**Author**: Based on OpenClaw Community  
**Created**: 2026-02-17
