# Swiss Design (International Typographic Style)

A design philosophy born in 1950s Switzerland that prioritizes clarity, objectivity, and mathematical precision. It treats design as a system, not decoration.

---

## Core Principles

1. Grid is Law — All layout decisions are governed by a strict modular grid system. Content aligns to invisible columns and baselines.
2. Typography as Architecture — Type is the primary design element. Use sans-serif typefaces (Helvetica, Neue Haas Grotesk, Univers, Aktiv Grotesk, Inter). Hierarchy is built through weight, size, and spacing — never decoration.
3. Objective Communication — Design serves content. Remove anything that doesn't communicate. No ornament, no gratuitous imagery.
4. Asymmetric Balance — Compositions favor asymmetry over centered layouts, creating dynamic visual tension within the grid.
5. Whitespace as Structure — Negative space is an active design element, not leftover emptiness. It creates rhythm and breathing room.
6. Photography over Illustration — When imagery is needed, use objective photography. Avoid stylized or illustrative graphics.

---

## Visual DNA

| Property | Value |
|---|---|
| **Border Radius** | 0px – 4px (sharp, geometric) |
| **Borders** | Thin rules (1px solid) used as grid dividers, not decoration |
| **Shadows** | None. Depth is achieved through layering and contrast |
| **Typography** | Sans-serif only. Large display type (48–120px), strict size scale |
| **Font Weight** | Bold (700–900) for headlines, Regular (400) for body |
| **Line Height** | Tight: 1.1 – 1.2 for headlines, 1.5 – 1.6 for body |
| **Letter Spacing** | Tight (-0.02em to -0.04em) for headlines |
| **Grid** | 12-column modular grid, strict alignment |
| **Colors** | Limited palette: 1–2 accent colors + black/white |

---

## Technical Standards

1. Grid First — Always start with grid grid-cols-12.
2. Horizontal Rules — Use border-t or border-b to section content.
3. Numbering — Index items with small numbers (01, 02) in a dedicated column.
4. Uppercase Captions — Small text is always uppercase with wide tracking (tracking-widest).
5. No Shadows — Elevation is communicated through contrast and spacing.

## Anti-Patterns

- Rounded corners > 4px
- Drop shadows or glows
- Gradient backgrounds
- Decorative illustrations
- Centered text layouts (except single-line captions)
