# AI Design Guidelines (Project Standard)

## Core Philosophy
- "Wong edan mah ajaib" (Crazy people are magical).
- Just enough engineering to get it done well. No bloat.
- High precision, high contrast, and mathematical grid alignment.

## Typography Standard
- Primary: Plus Jakarta Sans (tracking-tight for headings).
- Technical: JetBrains Mono (for metadata/stats).
- Scale: Strict hierarchy using consistent rem steps.

## Components & Visual DNA
- Borders: Bold (3px-4px) for Industrial/Neo-Brutalism; Rare/Invisible for Minimalism.
- Shadows: Hard offset for Industrial; Ambient low-opacity (2-5%) for Minimalism.
- Corners: Large (24px-32px) for M3/Industrial; Sharp (0px-4px) for Swiss.

## Color Usage
- Functional over decorative.
- Tonal pastels for backgrounds and highlights.
- Pure Ink (#000000) for primary text and borders.

## Interaction
- Snappy response times.
- Linear or Expo-out easing only.
- Clear tactile feedback on all interactive elements.
