# UI Design Fundamentals

The definitive guide for building production-grade web interfaces. Covers the full stack of design decisions from layout to motion, typography to accessibility.

## What's Inside

- Design philosophy and the 80/20 of design quality
- Layout patterns (Grid vs Flexbox decision tree, container strategy)
- Typography (font pairing by context, type scale, rules)
- Color (palette building, surface layering, WCAG contrast)
- Spacing (8px base unit scale, consistent rhythm)
- Visual hierarchy techniques
- Responsive design (breakpoint strategy, fluid techniques)
- Accessibility requirements (contrast, keyboard, focus, motion safety)
- Motion and animation timing guidelines
- Component states (hover, active, focus, disabled, loading)
- Design tokens architecture (three-layer system)
- Pre-delivery checklist

## When to Use

- Designing new UI components or pages
- Building landing pages, dashboards, or applications
- Reviewing code for design quality
- Creating distinctive interfaces that avoid generic aesthetics
- Implementing accessibility requirements

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/ui-design
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/ui-design .cursor/skills/ui-design
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/ui-design ~/.cursor/skills/ui-design
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/ui-design .claude/skills/ui-design
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/ui-design ~/.claude/skills/ui-design
```

## Related Skills

- [ui-ux-pro-max](../ui-ux-pro-max/) — Searchable design databases with CLI
- [web-design](../web-design/) — CSS implementation patterns
- [theme-factory](../theme-factory/) — Applying themes to artifacts
- [design-system-patterns](../design-system-patterns/) — Token architecture and theming

---

Part of the [Design Systems](..) skill category.
