# Checklist: Innovation & Originality

The 5 levels of the originality spectrum and when to use each.

---

## The Originality Spectrum

Not all design work requires innovation. Choose your level intentionally.

```
Lower Risk                                                    Higher Risk
Faster                                                        Slower
├─────────┼─────────┼─────────┼─────────┼─────────┤
Direct    Remixes   Indirect   Metaphors  True
Copies              Parallels  & Analogies Innovation
```

---

## Level 1: Direct Copies

**What:** Replicate existing design patterns exactly.

### When to Use

- Velocity is critical, differentiation isn't
- Users expect familiar patterns
- Internal tools, admin interfaces
- Proven patterns for common problems
- Low-stakes decisions

### How to Execute

☐ Identify the pattern you're copying
☐ Understand *why* it works (not just *what*)
☐ Copy the principles, adapt the details
☐ Ensure it fits your context
☐ Give credit where appropriate

### Examples

- Using a competitor's checkout flow structure
- Implementing Material Design's data table exactly
- Copying iOS settings page patterns

### Risks

- Legal issues (if copying proprietary designs too closely)
- Doesn't differentiate your product
- May not fit your specific context

---

## Level 2: Remixes

**What:** Combine elements from multiple sources into a new composition.

### When to Use

- Want some differentiation with low risk
- Multiple good patterns exist, none perfect
- Combining best practices from different products
- Adapting patterns to new contexts

### How to Execute

☐ Identify 2-3 source patterns
☐ Extract the best elements from each
☐ Combine intentionally (not randomly)
☐ Test the combination works cohesively
☐ Document the sources and your reasoning

### Examples

- Slack's message composer (combines messaging patterns from multiple products)
- Notion's database views (combines spreadsheet + database + card patterns)
- A mobile nav that combines iOS and Android conventions

### Risks

- Frankensteining (incoherent combinations)
- Losing what made original patterns work
- Overcomplicating by adding too many elements

---

## Level 3: Indirect Parallels

**What:** Draw inspiration from designs in different domains that solve similar problems.

### When to Use

- Direct competitors have similar solutions
- Looking for fresh perspectives
- The core problem is domain-agnostic
- Want to surprise users (positively)

### How to Execute

☐ Define the core problem (abstractly)
☐ Identify other domains with the same problem
☐ Research how those domains solve it
☐ Translate the solution to your context
☐ Validate it works for your users

### Examples

- Netflix content discovery → B2B product recommendations
- Video game skill trees → Learning platform progression
- Restaurant reservation flow → Meeting scheduling
- Music playlist curation → Content organization

### Good Cross-Domain Sources

- Gaming (engagement, progression, feedback)
- E-commerce (conversion, product display)
- Social media (engagement, sharing, discovery)
- Maps/navigation (wayfinding, spatial organization)
- Publishing (content hierarchy, reading experience)

### Risks

- Translation may not work across domains
- Users may not understand the metaphor
- Over-reaching can feel forced

---

## Level 4: Metaphors & Analogies

**What:** Use concepts from the real world to inform your design.

### When to Use

- Introducing new/unfamiliar concepts
- Making abstract concepts concrete
- Creating memorable mental models
- Building on existing user knowledge

### How to Execute

☐ Identify the concept users need to understand
☐ Find a familiar real-world analog
☐ Map the relationships (what matches, what doesn't)
☐ Use language and visuals from the metaphor
☐ Don't over-extend the metaphor

### Classic Metaphors in Software

| Metaphor | Software Concept |
|----------|-----------------|
| Desktop | OS file management |
| Folder | Directory |
| Trash can | Deleted files |
| Shopping cart | Checkout |
| Inbox | Messages |
| Library | Content collection |
| Dashboard | Metrics overview |
| Workspace | Project environment |

### Creating New Metaphors

☐ The metaphor should simplify, not complicate
☐ The mapping should be intuitive
☐ Don't force all aspects to match
☐ Test if users understand the metaphor
☐ Be consistent once you commit

### Risks

- Metaphor breaks down at edge cases
- Users don't share the cultural reference
- Constrains design to fit the metaphor
- Can feel gimmicky if overdone

---

## Level 5: True Innovation

**What:** Create entirely new design patterns from first principles.

### When to Use

- Existing patterns don't solve the problem
- Creating a new product category
- Technical breakthrough enables new interactions
- Differentiation is critical competitive advantage
- You have time and resources to iterate

### How to Execute

☐ Define the problem from first principles
☐ Question all assumptions about current solutions
☐ Explore multiple radical approaches
☐ Prototype and test extensively
☐ Be prepared to fail and iterate
☐ Document your learnings

### First Principles Questions

- What is the user actually trying to accomplish?
- Why do we do it this way? What if we didn't?
- What constraints are real vs. assumed?
- What would this look like with no constraints?
- What new technology/capability enables a different approach?

### Examples of True Innovation

- iPhone's multitouch interface (2007)
- Notion's blocks-based content model
- Figma's multiplayer design editing
- Linear's keyboard-first interface
- Superhuman's command-k pattern

### Risks

- High failure rate
- Significant time and resource investment
- Users may not adopt unfamiliar patterns
- May solve a problem users don't have
- Competitors can copy if successful

---

## Choosing Your Level

### Decision Framework

| Factor | Lower Originality | Higher Originality |
|--------|------------------|-------------------|
| Time available | Limited | Ample |
| Risk tolerance | Low | High |
| User sophistication | General | Early adopters |
| Market maturity | Established | Emerging |
| Differentiation need | Low | Critical |
| Pattern clarity | Clear best practice | No clear winner |

### By Context

| Context | Recommended Level |
|---------|------------------|
| Internal tools | 1 (Direct copies) |
| Commodity features | 1-2 (Copies, Remixes) |
| Core product features | 2-3 (Remixes, Parallels) |
| Key differentiators | 3-4 (Parallels, Metaphors) |
| New categories | 4-5 (Metaphors, Innovation) |

---

## Innovation Process

When pursuing higher originality levels:

### 1. Diverge Widely

- Generate many options (10+)
- Include "bad" ideas
- Cross-pollinate from unexpected sources
- Don't evaluate while generating

### 2. Prototype Rapidly

- Build to learn, not to ship
- Test core assumptions early
- Fail fast, learn faster
- Increase fidelity incrementally

### 3. Validate Thoroughly

- Test with real users
- Measure against JTBD
- Compare to existing solutions
- Be willing to abandon

### 4. Document Learnings

- What worked and didn't
- Unexpected discoveries
- Principles that emerged
- Recommendations for future

---

## Innovation Audit

Before pursuing originality:

| Question | Answer |
|----------|--------|
| Why is innovation needed here? | |
| What's the risk if we fail? | |
| Do we have time to iterate? | |
| What's our differentiation goal? | |
| What's the simplest option that might work? | |
| Have we validated user need? | |
