# The 7 Anchors: Foundational Mindsets

Anchors are mental models and principles that form your foundation. They keep you grounded when product development gets chaotic.

## Why Anchors Matter

1. **Clarity in chaos** — Quickly align decisions with core values when juggling priorities
2. **Confidence** — Make bold decisions under pressure
3. **Resilience** — Bounce back from setbacks
4. **Growth** — Framework for continuous learning (anchors evolve with you)

---

## Anchor 1: Pursue Your Purpose

**What:** Connect your work to a larger purpose. Inspired by Ikigai (reason for being).

**The 4 Elements:**
- What you love
- What you're good at
- What the world needs
- What you can be paid for

**When to rely on it:**
- Deciding which projects to take on
- Feeling unfulfilled or burnt out
- Prioritizing features or initiatives
- Considering career moves

**How to apply:**
- Define a personal mission statement
- Evaluate projects against the 4 elements
- Prioritize purpose-aligned work
- Connect even mundane tasks to larger goals
- Regularly reflect on alignment

---

## Anchor 2: Embrace the Marathon Mindset

**What:** Product design is a long game, not a sprint. Sustainable pace beats heroic bursts.

**Key principles:**
- Burnout is a feature, not a bug, of unsustainable work
- Small consistent progress compounds
- Recovery is part of the work
- Career success is measured in decades, not sprints

**When to rely on it:**
- Facing unrealistic deadlines
- Tempted to sacrifice quality for speed
- Building habits and systems
- Evaluating trade-offs with long-term consequences

**How to apply:**
- Protect your energy and attention
- Build systems, not just outputs
- Say no to protect yes
- Invest in learning that compounds

---

## Anchor 3: Be Intentional

**What:** Every design decision should be traceable to a reason. Accidental design is reckless design.

**Intentionality spectrum:**
- Unconscious incompetence (don't know what you don't know)
- Conscious incompetence (know gaps, learning)
- Conscious competence (deliberate, effortful mastery)
- Unconscious competence (intuitive mastery)

**When to rely on it:**
- Making any design decision
- Explaining choices to stakeholders
- Reviewing others' work
- Feeling autopilot taking over

**How to apply:**
- Document your reasoning
- Challenge "it's always been done this way"
- Ask "why this choice?" for every element
- Build decision logs

---

## Anchor 4: Embrace Your Unique Perspective

**What:** Your specific combination of experiences, skills, and viewpoints is an asset, not a liability.

**Key insight:** The industry doesn't need more average designers. It needs your particular blend of weird.

**When to rely on it:**
- Feeling imposter syndrome
- Comparing yourself to others
- Deciding what to learn next
- Positioning yourself professionally

**How to apply:**
- Identify your unique combination of skills
- Lean into interests others find "off-topic"
- Share your perspective, especially when different
- Build on strengths rather than only fixing weaknesses

---

## Anchor 5: Practice Just-in-Time Learning

**What:** Learn what you need when you need it, not in advance "just in case."

**Why it matters:**
- Knowledge decays without application
- The field changes faster than curricula
- Context makes learning stick
- You can't pre-learn everything

**When to rely on it:**
- Feeling overwhelmed by what you "should" know
- Deciding what to learn next
- Facing an unfamiliar problem
- Evaluating courses/resources

**How to apply:**
- Learn in response to real problems
- Apply immediately after learning
- Maintain a "learn when needed" list vs. "learn someday" list
- Trust your ability to figure things out

---

## Anchor 6: Challenge Assumptions

**What:** Actively question what "everyone knows" and what you've always believed.

**Common assumption traps:**
- "Users would never..."
- "That's just how it's done..."
- "The data shows..." (but does it really?)
- "We tried that and it didn't work" (in what context?)

**When to rely on it:**
- Inheriting existing designs
- Hearing "we've always done it this way"
- Receiving secondhand user feedback
- Feeling certain about something unvalidated

**How to apply:**
- Ask "what would have to be true for this assumption to be false?"
- Seek disconfirming evidence, not just confirming
- Run cheap experiments before committing
- Distinguish observation from interpretation

---

## Anchor 7: Two Truths Exist

**What:** Seemingly contradictory ideas can both be true simultaneously. Embrace paradox instead of forcing false choices.

**Examples:**
- Design can be both fast AND thoughtful
- Simplicity requires complexity in implementation
- User needs AND business needs can coexist
- Convention AND innovation both have value
- Data AND intuition are both valid inputs

**When to rely on it:**
- Facing "either/or" framing
- Mediating stakeholder conflicts
- Feeling stuck between opposing ideas
- Making trade-off decisions

**How to apply:**
- Reframe "or" as "and" — how might both be true?
- Look for higher-order solutions that satisfy multiple constraints
- Accept tension as feature, not bug
- Avoid premature resolution of ambiguity

---

## Using Anchors in Practice

**Before a project:** Review relevant anchors, set intentions

**During pressure:** Pause, identify which anchor applies, act accordingly

**After setbacks:** Return to anchors to regain footing

**Periodically:** Reflect on how your anchors are evolving

Anchors aren't rules to follow—they're foundations to build on.
