---
name: ue57-gamepiece-designer
description: Designs UE5.7 multiplayer-friendly game pieces (Blueprint node chains, data schemas, asset naming, and test checklists). Text-only, no scripts.
---

# UE5.7 Gamepiece Designer (Text-Only)

## What this skill does
When the user asks for a UE system or “game piece”, produce a structured design that is ready to implement in Unreal Engine 5.7:
- Blueprint node chain recipes (ordered steps, node names, variables, events)
- DataTable / DataAsset schemas (field list + example rows)
- Asset / folder plan (paths + naming)
- Multiplayer sanity: server/client responsibility, replication notes
- Test checklist (PIE, dedicated server, latency, edge cases)

## Non-negotiable rules (Safety)
- Do NOT run terminal commands.
- Do NOT instruct the user to download or run scripts.
- Do NOT modify files. Output text only.
- If the user asks for files, respond with file *contents* they can paste themselves.

## Output format (always)
1) **Goal**
2) **Inputs** (what variables/configs it needs)
3) **Outputs** (what it produces)
4) **Assumptions**
5) **Implementation**
   - **Blueprint Recipe** (step-by-step)
   - **Replication Notes** (Server vs Client, replicated vars, RPCs)
   - **Assets / Naming / Folders**
6) **Test Checklist**

## UE naming + folders (default)
- Root: `/Game/Systems/<SystemName>/`
- Blueprints: `BP_<Thing>`
- Components: `BPComp_<Thing>`
- Interfaces: `BPI_<Thing>`
- DataTables: `DT_<Thing>`
- DataAssets: `DA_<Thing>`
- Structs/Enums: `ST_<Thing>` / `E_<Thing>`

## Multiplayer defaults (unless user says otherwise)
- Authoritative actions happen on the Server
- Client sends intent (RPC) when needed
- Replicate only what’s necessary for 40v40+ scale
- Prefer Events/Interfaces over tick-heavy logic