# Style Tags — Udio

Quick reference for style descriptors that Udio responds to effectively.

## Genre Tags

### Electronic
| Primary | Subgenres |
|---------|-----------|
| electronic | ambient, IDM, downtempo, chillwave |
| techno | minimal, industrial, acid, Detroit |
| house | deep house, progressive, tech house |
| trance | uplifting, psytrance, goa |
| drum and bass | liquid, jungle, neurofunk |
| dubstep | brostep, melodic dubstep, riddim |
| synthwave | retrowave, darksynth, outrun |

### Rock
| Primary | Subgenres |
|---------|-----------|
| rock | alternative, indie rock, hard rock |
| metal | heavy metal, thrash, doom, black metal |
| punk | pop punk, hardcore, post-punk |
| grunge | 90s grunge, Seattle sound |
| shoegaze | dreampop, noise pop |
| post-rock | atmospheric, cinematic |

### Hip Hop / R&B
| Primary | Subgenres |
|---------|-----------|
| hip hop | boom bap, trap, conscious |
| rap | old school, mumble, lyrical |
| r&b | neo soul, contemporary r&b |
| lo-fi | lo-fi hip hop, chillhop |

### Pop
| Primary | Subgenres |
|---------|-----------|
| pop | synth pop, electropop, art pop |
| indie pop | chamber pop, baroque pop |
| k-pop | j-pop |

### Jazz / Blues
| Primary | Subgenres |
|---------|-----------|
| jazz | bebop, cool jazz, free jazz |
| fusion | jazz fusion, jazz funk |
| blues | delta blues, Chicago blues |
| soul | motown, northern soul |

### Classical
| Primary | Subgenres |
|---------|-----------|
| classical | baroque, romantic, contemporary |
| orchestral | film score, cinematic |
| chamber | string quartet, piano solo |
| opera | aria, choral |

### World / Folk
| Primary | Subgenres |
|---------|-----------|
| folk | indie folk, traditional |
| country | americana, bluegrass |
| latin | salsa, bossa nova, reggaeton |
| world | afrobeat, celtic, middle eastern |

## Mood Tags

### Energy Level
| Low | Medium | High |
|-----|--------|------|
| calm | groovy | energetic |
| peaceful | steady | explosive |
| tranquil | flowing | intense |
| serene | relaxed | powerful |
| meditative | comfortable | driving |

### Emotional Tone
| Positive | Neutral | Negative |
|----------|---------|----------|
| happy | mysterious | sad |
| joyful | contemplative | melancholic |
| euphoric | introspective | dark |
| uplifting | thoughtful | ominous |
| triumphant | nostalgic | aggressive |
| hopeful | bittersweet | haunting |

### Atmosphere
| Light | Balanced | Heavy |
|-------|----------|-------|
| airy | warm | dense |
| bright | rich | thick |
| ethereal | full | massive |
| floating | layered | crushing |
| delicate | textured | overwhelming |

## Instrument Tags

### Strings
- acoustic guitar, electric guitar, classical guitar
- violin, viola, cello, double bass
- string quartet, string orchestra
- harp, mandolin, banjo

### Keys
- piano, grand piano, upright piano
- synthesizer, synth pads, synth leads
- organ, hammond organ, church organ
- rhodes, wurlitzer, electric piano

### Percussion
- drums, acoustic drums, electronic drums
- 808, 909, drum machine
- percussion, hand percussion
- brushes, rim shots, breakbeat

### Brass / Winds
- trumpet, saxophone, trombone
- flute, clarinet, oboe
- brass section, horn section
- orchestra winds

### Electronic
- synth bass, sub bass
- arpeggiator, sequencer
- pad, lead, pluck
- glitch, granular, modular

## Voice Tags

### Gender / Range
- male vocals, female vocals
- soprano, alto, tenor, baritone, bass
- androgynous, gender neutral

### Style
- clean vocals, raspy, breathy
- powerful, belting, whispered
- falsetto, head voice, chest voice
- spoken word, rap flow

### Treatment
- reverb vocals, dry vocals
- doubled, harmonized, choir
- processed, vocoder, autotune
- distant, intimate, close mic

### Descriptor
- emotional, passionate, detached
- smooth, rough, gritty
- ethereal, angelic, demonic
- soulful, robotic

## Production Tags

### Era
- vintage, retro, modern, futuristic
- 60s, 70s, 80s, 90s, 2000s
- classic, contemporary

### Quality
- lo-fi, hi-fi
- polished, raw, rough
- professional, bedroom production
- tape, vinyl, digital

### Space
- intimate, roomy, cavernous
- dry, wet, reverberant
- close, distant, spacious
- mono, stereo, wide

### Texture
- clean, distorted, saturated
- smooth, gritty, crunchy
- warm, cold, bright
- soft, hard, punchy

## Combination Examples

### Chill Electronic
```
electronic ambient downtempo dreamy warm lo-fi synth pads
```

### Energetic Rock
```
indie rock upbeat energetic driving electric guitar powerful drums
```

### Emotional Ballad
```
pop ballad emotional piano female vocals intimate sad powerful
```

### Dark Cinematic
```
orchestral cinematic dark ominous strings brass epic tension building
```

### Vintage Soul
```
soul motown vintage 60s warm analog smooth male vocals brass section
```
