# Content Production

## Script Writing

### From Bullet Points to Script

Given rough notes, generate conversational scripts:

**Input:** Topic + key points
**Output:** Natural-sounding script with:
- Clear introduction stating what this lecture covers
- Logical flow between points
- [VISUAL CUE] markers for slides/demos
- Summary at end

### Script Formula

```
1. Hook (10 sec): Why this matters
2. Overview (20 sec): What we'll cover
3. Content (3-10 min): Main teaching
4. Summary (30 sec): Key takeaways
5. Transition (10 sec): What's next
```

### Voice Consistency

If generating multiple scripts, maintain:
- Same level of formality throughout
- Consistent terminology (don't alternate "app/application")
- Similar pacing and structure
- Unified personality (enthusiastic, calm, technical, etc.)

## Slide Decks

### Slide Types

| Type | When to Use |
|------|-------------|
| Title | Section/lecture intro |
| Bullet points | Listing concepts (max 5 points) |
| Code | Technical demonstrations |
| Diagram | Explaining relationships/flow |
| Image | Concrete examples, screenshots |
| Quote | Expert opinions, key statements |

### Design Principles

- One idea per slide
- Readable font size (24pt minimum)
- Consistent color scheme throughout course
- Avoid walls of text — bullets or visuals
- Include instructor video overlay where possible

## Quiz & Assignment Creation

### Quiz Best Practices

- Test comprehension, not memorization
- 4-6 questions per section
- Mix question types (multiple choice, true/false)
- Include explanations for correct answers

### Assignment Types

| Assignment | Best For |
|------------|----------|
| Practice project | Hands-on skills |
| Reflection questions | Concept understanding |
| Case study analysis | Real-world application |
| Peer review | Community engagement |

## Supplementary Materials

Create downloadable resources students value:
- Cheat sheets (1-2 pages, reference format)
- Templates (fillable documents they'll use)
- Checklists (step-by-step for complex processes)
- Resource lists (curated links, tools, further reading)
- Code files (starter/solution for each project)

## Production Workflow

### Batch Recording

Prepare multiple lectures before recording:
1. Write/finalize all scripts
2. Create all slides
3. Set up recording environment
4. Record similar types together (all screencasts, then all talking head)
5. Edit in batches

### Quality Checklist

Before uploading:
- [ ] Audio clear, consistent volume
- [ ] Video 1080p minimum
- [ ] No long pauses or "ums"
- [ ] Captions accurate
- [ ] Links/resources work
- [ ] Code runs correctly
