# Course Planning

## Niche Research

Before committing to a topic, validate demand vs competition:

**Analyze:**
- Search volume on Udemy for topic keywords
- Number of existing courses in the category
- Review quality of top 5 competitors
- Price points and enrollment estimates
- Gaps identified from negative reviews

**Red flags:**
- Oversaturated niche with 50+ courses
- Top courses have <100 reviews (low demand)
- Trending topic that may fade quickly

**Green flags:**
- High demand, few quality options
- Negative reviews mention specific missing topics
- Your unique angle or expertise differentiates

## Competitor Analysis

For each top competitor course, extract:
- Complete curriculum structure
- Course length and pacing
- Teaching style (lecture, hands-on, mixed)
- What reviews praise
- What reviews criticize as missing

**Opportunity formula:** Find what students want but aren't getting.

## Curriculum Design

### Structure Template

```
Section 1: Introduction (10-15 min)
- Welcome & course overview
- What you'll learn
- Prerequisites & setup

Sections 2-N: Core Content (bulk of course)
- Each section: one major topic
- Lectures: 5-15 minutes each
- Include quizzes at section end
- Add assignments for hands-on practice

Final Section: Wrap-up (10-15 min)
- Summary & key takeaways
- Next steps
- Bonus resources
```

### Pacing Guidelines

| Course Type | Total Length | Lecture Length |
|-------------|--------------|----------------|
| Crash course | 1-2 hours | 3-8 min |
| Comprehensive | 5-15 hours | 5-15 min |
| Masterclass | 20+ hours | 10-20 min |

### Learning Objectives

Each section should have 2-4 specific, measurable objectives:
- "By the end of this section, you will be able to [action verb] [specific skill]"
- Use: build, create, implement, configure, troubleshoot
- Avoid: understand, know, learn (too vague)

## For Non-Experts (Side Hustlers)

If you're curating rather than teaching from expertise:

1. **Deep research phase** — Compile from multiple authoritative sources
2. **Synthesis** — Organize into a coherent learning path
3. **Validation** — Have an expert review for accuracy (or state your limitations)
4. **Unique value** — Your organization and presentation IS the value

**Warning:** Don't misrepresent expertise. Be honest about being a "guide" vs "guru."

## For Educators Converting Classroom Content

1. **Break down** — 90-min lectures become 6-10 shorter segments
2. **Add interactivity** — Quizzes replace live Q&A
3. **Remove assumed knowledge** — Explain what you'd normally answer on the spot
4. **Update for online** — Classroom examples may need context for global audience
