# Marketing & Publishing

## Course Title

**Formula:** [Result/Skill]: [Specificity] + [Benefit]

**Examples:**
- "React Complete Guide: Build Modern Web Apps from Scratch"
- "Data Science Bootcamp: Python, ML, and Real Projects"

**Rules:**
- Lead with the main keyword
- Include differentiator (complete, bootcamp, masterclass)
- Mention key technologies/outcomes
- 60 characters max for full visibility

## Course Description

### Structure

```
**Opening hook** (2-3 sentences)
Why this course? What problem does it solve?

**What you'll learn** (bullet list)
- Specific, actionable outcomes
- 5-8 key takeaways

**Who this is for** (paragraph)
Target audience description

**Prerequisites** (if any)
What students need before starting

**Course structure** (optional)
Brief overview of sections

**About the instructor** (brief)
Credentials without bragging

**AI disclosure** (required)
"This course contains content created with the assistance of AI tools."
```

### SEO Optimization

- Include primary keyword in first 100 characters
- Use secondary keywords naturally
- Avoid keyword stuffing
- Match language to how students search

## Pricing Strategy

| Course Length | Suggested Range | Notes |
|---------------|-----------------|-------|
| 1-3 hours | $19.99-$49.99 | Entry-level, crash courses |
| 4-10 hours | $49.99-$99.99 | Comprehensive courses |
| 10+ hours | $99.99-$199.99 | In-depth, flagship courses |

**Consider:**
- Competitor pricing in your niche
- Your instructor reputation (new vs established)
- Included materials and support level
- Udemy's frequent sales (your price is rarely paid)

## Thumbnail Design

**Must have:**
- Bold, readable text
- Your face (increases trust)
- High contrast colors
- Works at small size (search results)

**Avoid:**
- Too much text
- Cluttered design
- Overused stock photos
- Hard-to-read fonts

## Promotional Video

**2-minute structure:**
1. **Hook** (15 sec): Problem statement
2. **Solution** (30 sec): What the course delivers
3. **Credibility** (20 sec): Why you're qualified
4. **Preview** (40 sec): Show actual course content
5. **CTA** (15 sec): Enroll now, what they'll gain

## Launch Strategy

### Pre-launch
- Build email list of interested students
- Create free content previewing course value
- Gather early reviewers (friends, colleagues)

### Launch Week
- Discounted "early bird" pricing
- Social media announcements
- Reach out to complementary instructors

### Post-launch
- Monitor first reviews carefully
- Respond to all Q&A promptly
- Fix any issues immediately
- Gather testimonials from satisfied students
