# Legal Compliance

## Udemy GenAI Policy Summary

Udemy explicitly permits AI-assisted course creation but requires:
- **Disclosure** in course description when AI is used
- **Meaningful instructor participation** — not just reviewing AI output
- **Quality standards** — AI content must be polished, accurate, relevant
- **Human expertise** — courses must demonstrate genuine instructor knowledge

## What Gets Courses Rejected

- Fully AI-generated content with minimal human input
- Content that's inaccurate, misleading, or has factual errors
- Poor quality AI visuals (pixelation, irrelevance)
- Grammar, syntax, or coherence issues from raw AI output
- Bulk low-quality courses suggesting AI spam

## Disclosure Requirements

**Mandatory disclosure in course description:**
```
This course contains content created with the assistance of artificial intelligence tools.
```

**When to disclose:**
- Scripts written with AI assistance
- Slides or graphics generated by AI
- Research compiled using AI tools
- Quizzes or assignments generated by AI

**Grace period:** 3 months for existing courses (as of Nov 2025)

## Legal Risks for Course Creators

### Copyright
- You're responsible for all content, including AI outputs
- Verify AI-generated content doesn't infringe third-party IP
- Keep records of your prompts and AI tool usage

### Platform Violations
- Course rejection during Quality Review
- Content disabled after publication
- Repeated violations = account suspension or permanent removal

### Refund Liability
- Students can request refunds per Udemy Terms
- Instructors receive no revenue from refunded transactions
- Udemy can deduct from future payments if refund occurs after payout

## Safe Practices

1. Use AI as assistant, not sole creator
2. Review and edit ALL AI outputs before using
3. Add unique personal expertise and real-world examples
4. Prioritize quality over production speed
5. Disclose AI usage proactively
6. Keep documentation of your creation process

## What NOT to Do

- Claim AI-generated content is human-created
- Circumvent Udemy's quality review process
- Mass-produce courses without quality control
- Use AI to generate content you can't verify for accuracy
- Ignore student feedback about AI-related quality issues

## Resources

- Udemy Instructor Terms: udemy.com/terms/instructor/
- GenAI Policy: udemy.com/terms/genai-instructor-policy/
- Course Quality Checklist: support.udemy.com/hc/articles/30999984483607
