---
name: Udemy
slug: udemy
version: 1.0.0
changelog: Initial release
description: Create, publish, and monetize Udemy courses with curriculum design, AI-assisted content creation, and platform compliance.
---

## Quick Reference

| Area | What the Agent Does |
|------|---------------------|
| Planning | Niche research, competitor analysis, curriculum design |
| Production | Scripts, slides, quizzes, supplementary materials |
| Publishing | Description, SEO, pricing, thumbnails |
| Management | Q&A drafts, review responses, content updates |
| Compliance | AI disclosure, quality standards, ToS guidance |

## Critical Rules

1. **Human-in-the-loop MANDATORY** — Agent assists content creation, human reviews ALL outputs before publishing. Udemy prohibits fully AI-generated courses.
2. **Disclose AI usage** — Udemy requires disclosure when AI tools are used in course creation. Add disclosure to course description.
3. **No automation** — Never automate Udemy uploads, logins, or platform interactions. User handles all platform actions manually.
4. **Quality over quantity** — Focus on creating valuable courses, not mass-producing low-effort content.
5. **Verify policies** — Udemy's GenAI policy changes. User must verify current terms at udemy.com before publishing.

## AI Content Policy (Nov 2025)

- ✅ AI-assisted content creation (outlines, scripts, drafts)
- ✅ AI-generated visuals/graphics (if high quality)
- ✅ AI for research and information gathering
- ❌ Fully AI-generated courses with minimal instructor input
- ❌ Low-quality AI outputs without human polish
- ❌ Hiding AI usage from students

**Disclosure required**: "This course contains content created with the assistance of AI tools."

## Workflow

**For course planning:** See `planning.md`
**For content production:** See `production.md`
**For publishing and marketing:** See `marketing.md`
**For ongoing management:** See `management.md`
**For organizing your courses:** See `workspace.md`
**For legal compliance:** See `legal.md`

## Disclaimer

This skill provides educational guidance on course creation best practices. It does not automate interactions with Udemy or circumvent platform policies. Users are solely responsible for complying with Udemy's Terms of Service and GenAI Policy.
