# Web Research Assistant

A skill that enables Claw to perform structured web research on any topic, synthesize findings from multiple sources, and produce a well-organized summary with citations.

## What This Skill Does

This skill guides Claw through a systematic web research workflow:

1. **Query Formulation** — Break down a broad research question into specific, targeted search queries
2. **Multi-Source Gathering** — Search across multiple sources to collect diverse perspectives and data points
3. **Source Evaluation** — Assess credibility and relevance of each source
4. **Synthesis** — Combine findings into a coherent, structured summary
5. **Citation** — Provide proper attribution with URLs for all referenced material

## How to Use

Ask Claw to research any topic:

- "Research the current state of quantum computing and summarize key breakthroughs from the past year"
- "Find and compare the pricing models of the top 5 cloud providers"
- "Investigate the environmental impact of electric vehicles vs. traditional cars"

## Output Format

The skill produces a structured research report containing:

- **Executive Summary** — A 2-3 sentence overview of key findings
- **Detailed Findings** — Organized by subtopic with supporting evidence
- **Source List** — All URLs and publication dates referenced
- **Confidence Assessment** — How well-supported each finding is across sources

## Best Practices

- Be specific in your research question for more focused results
- Specify a time range if you need recent information (e.g., "in the last 6 months")
- Mention if you need a particular perspective (technical, business, consumer, etc.)
- Request a specific output format if the default doesn't suit your needs
