---
name: typescript-lsp
description: TypeScript language server providing type checking, code intelligence, and LSP diagnostics for .ts, .tsx, .js, .jsx, .mts, .cts, .mjs, .cjs files. Use when working with TypeScript or JavaScript code that needs type checking, autocomplete, error detection, refactoring support, or code navigation.
---

# TypeScript LSP

TypeScript/JavaScript language server integration providing comprehensive code intelligence through typescript-language-server.

## Capabilities

- **Type checking**: Static analysis of TypeScript and JavaScript types
- **Code intelligence**: Autocomplete, go-to-definition, find references, rename symbols
- **Error detection**: Real-time diagnostics for type errors, syntax issues, and semantic problems
- **Refactoring**: Extract function/variable, organize imports, quick fixes
- **Supported extensions**: `.ts`, `.tsx`, `.js`, `.jsx`, `.mts`, `.cts`, `.mjs`, `.cjs`

## Installation

Install TypeScript language server and TypeScript compiler:

```bash
npm install -g typescript-language-server typescript
```

Or with yarn:
```bash
yarn global add typescript-language-server typescript
```

Verify installation:
```bash
typescript-language-server --version
tsc --version
```

## Usage

The language server runs automatically in LSP-compatible editors. For manual type checking:

```bash
tsc --noEmit  # Type check without generating output files
```

Compile TypeScript files:

```bash
tsc src/index.ts
```

Watch mode for continuous type checking:

```bash
tsc --watch --noEmit
```

## Configuration

Create `tsconfig.json` in project root:

```json
{
  "compilerOptions": {
    "target": "ES2020",
    "module": "ESNext",
    "strict": true,
    "esModuleInterop": true,
    "skipLibCheck": true,
    "forceConsistentCasingInFileNames": true,
    "resolveJsonModule": true,
    "moduleResolution": "node"
  },
  "include": ["src/**/*"],
  "exclude": ["node_modules", "dist"]
}
```

## Integration Pattern

When editing TypeScript/JavaScript code:
1. Run `tsc --noEmit` after significant changes
2. Address type errors before committing
3. Use `tsc --watch` during active development
4. Leverage quick fixes for common issues

## Common Flags

- `--noEmit`: Type check only, no output files
- `--strict`: Enable all strict type checking options
- `--watch`: Watch mode for continuous compilation
- `--project <path>`: Specify tsconfig.json location
- `--pretty`: Stylize errors and messages

## More Information

- [typescript-language-server on npm](https://www.npmjs.com/package/typescript-language-server)
- [GitHub Repository](https://github.com/typescript-language-server/typescript-language-server)
- [TypeScript Official Documentation](https://www.typescriptlang.org/docs/)
- [TypeScript Compiler Options](https://www.typescriptlang.org/tsconfig)
