---
name: twitter-post
description: Post tweets to Twitter/X via the official API v2 (OAuth 1.0a). Use when the user asks to tweet, post to Twitter/X, send a thread, reply to a tweet, or quote tweet. Supports single tweets, threads, replies, and quote tweets with automatic character weight validation.
---

# Twitter Post

Post tweets via the official Twitter/X API v2 using OAuth 1.0a authentication.

## Prerequisites

Four environment variables must be set. Obtain them from [developer.x.com](https://developer.x.com):

```
TWITTER_CONSUMER_KEY=<API Key>
TWITTER_CONSUMER_SECRET=<API Key Secret>
TWITTER_ACCESS_TOKEN=<Access Token>
TWITTER_ACCESS_TOKEN_SECRET=<Access Token Secret>
```

Optional:
- `HTTPS_PROXY` — HTTP proxy URL (e.g. `http://127.0.0.1:7897`) for regions that need it
- `TWITTER_DRY_RUN=1` — validate and print without posting

## Setup

Store credentials as env vars. Recommended: add to the OpenClaw instance config or export in shell profile. **Never hardcode keys in SKILL.md or scripts.**

If the user hasn't set up OAuth yet, guide them:

1. Go to [developer.x.com](https://developer.x.com) → Dashboard → Create App
2. Set **App permissions** to **Read and Write**
3. Go to **Keys and tokens** tab
4. Copy API Key, API Key Secret
5. Generate Access Token and Access Token Secret (ensure Read+Write scope)
6. If the portal only shows Read, use PIN-based OAuth flow:
   - Call `POST /oauth/request_token` with `oauth_callback=oob`
   - User opens `https://api.twitter.com/oauth/authorize?oauth_token=<token>`
   - User provides the PIN code
   - Call `POST /oauth/access_token` with the PIN as `oauth_verifier`

## Usage

All commands via `exec`. Script path: `scripts/tweet.js` (relative to this skill directory).

### Single tweet

```bash
node scripts/tweet.js "Your tweet content here"
```

### Reply to a tweet

```bash
node scripts/tweet.js --reply-to 1234567890 "Reply text"
```

### Quote tweet

```bash
node scripts/tweet.js --quote 1234567890 "Your commentary"
```

### Thread (multiple tweets)

```bash
node scripts/tweet.js --thread "First tweet" "Second tweet" "Third tweet"
```

### Output

JSON to stdout:

```json
{"ok":true,"id":"123456789","url":"https://x.com/i/status/123456789","remaining":"99","limit":"100"}
```

On error: `{"ok":false,"error":"..."}`

## Character Limits

- Max 280 weighted characters per tweet
- CJK characters (Chinese/Japanese/Korean) count as **2** each
- URLs count as **23** each regardless of length
- Script auto-validates before posting; rejects if over limit

## Rate Limits

- **100 tweets / 15 min** per user (OAuth 1.0a)
- **3,000 tweets / month** on Basic plan ($200/mo)
- Check `remaining` field in output to monitor quota

## Tips

- For content from Notion/database: fetch the text first, then pipe to `tweet.js`
- For cron-based auto-posting: use `exec` with env vars set, parse JSON output to confirm success
- Thread mode posts sequentially; each tweet auto-replies to the previous one
- Combine `--thread` with `--reply-to` to attach a thread under an existing tweet
