{
  "name": "twitter_operations",
  "description": "Comprehensive Twitter/X platform automation and management",
  "version": "1.0.0",
  "category": "social_media",
  "enabled": true,
  "triggers": ["twitter", "tweet", "x.com", "social media", "twitter api"],
  "capabilities": [
    "Post tweets and threads",
    "Schedule tweets for optimal engagement times",
    "Reply to mentions and direct messages",
    "Search tweets by keywords, hashtags, or users",
    "Monitor trending topics and hashtags",
    "Analyze tweet performance and engagement metrics",
    "Follow/unfollow users based on criteria",
    "Like and retweet content",
    "Create and manage Twitter lists",
    "Track follower growth and analytics",
    "Implement Twitter bot functionality",
    "Scrape tweets and user profiles",
    "Generate tweet content with optimal hashtags",
    "Manage multiple Twitter accounts",
    "Monitor brand mentions and sentiment",
    "Auto-reply to specific keywords or patterns",
    "Archive tweets and user data",
    "Create Twitter polls",
    "Upload and manage media (images, videos, GIFs)",
    "Implement rate limiting and API quota management",
    "Handle Twitter authentication (OAuth 1.0a/2.0)",
    "Parse and format tweet metadata",
    "Export analytics to CSV/JSON",
    "Real-time streaming of tweets",
    "Detect and respond to specific user interactions",
    "Bulk operations (mass follow/unfollow/block)",
    "Twitter Spaces monitoring and participation",
    "Community management and moderation",
    "Hashtag performance tracking",
    "Competitor account monitoring"
  ],
  "parameters": {
    "api_version": "v2",
    "auth_type": "oauth2",
    "rate_limit_mode": "conservative",
    "max_tweets_per_request": 100,
    "default_tweet_count": 10,
    "retry_attempts": 3,
    "timeout_seconds": 30,
    "media_upload_max_size_mb": 5,
    "thread_delay_seconds": 2,
    "auto_hashtag_limit": 5,
    "sentiment_analysis": true,
    "enable_streaming": false,
    "archive_tweets": true
  },
  "dependencies": [
    "tweepy>=4.14.0",
    "python-twitter-v2>=0.9.0",
    "requests>=2.31.0",
    "requests-oauthlib>=1.3.1",
    "python-dotenv>=1.0.0",
    "pandas>=2.0.0",
    "beautifulsoup4>=4.12.0",
    "schedule>=1.2.0",
    "textblob>=0.17.1",
    "Pillow>=10.0.0"
  ],
  "configuration": {
    "credentials_file": "~/.openclaw/twitter_credentials.json",
    "cache_dir": "~/.openclaw/cache/twitter",
    "log_file": "~/.openclaw/logs/twitter.log",
    "archive_dir": "~/.openclaw/archives/twitter"
  },
  "api_endpoints": {
    "tweet": "/2/tweets",
    "search": "/2/tweets/search/recent",
    "users": "/2/users",
    "timeline": "/2/users/:id/tweets",
    "likes": "/2/users/:id/likes",
    "retweets": "/2/tweets/:id/retweets",
    "followers": "/2/users/:id/followers",
    "following": "/2/users/:id/following",
    "spaces": "/2/spaces",
    "lists": "/2/lists",
    "media": "/1.1/media/upload"
  },
  "examples": [
    {
      "action": "post_tweet",
      "description": "Post a simple tweet",
      "command": "openclaw twitter post 'Hello from OpenClaw! #automation'"
    },
    {
      "action": "post_thread",
      "description": "Post a Twitter thread",
      "command": "openclaw twitter thread 'Thread part 1' 'Thread part 2' 'Thread part 3'"
    },
    {
      "action": "search_tweets",
      "description": "Search for recent tweets",
      "command": "openclaw twitter search '#AI OR #MachineLearning' --count 50"
    },
    {
      "action": "get_trends",
      "description": "Get trending topics",
      "command": "openclaw twitter trends --location 'United States'"
    },
    {
      "action": "analyze_account",
      "description": "Analyze a Twitter account",
      "command": "openclaw twitter analyze @username --metrics engagement,growth"
    },
    {
      "action": "schedule_tweet",
      "description": "Schedule a tweet for later",
      "command": "openclaw twitter schedule 'My scheduled tweet' --time '2026-02-03 10:00'"
    },
    {
      "action": "auto_reply",
      "description": "Set up auto-reply for mentions",
      "command": "openclaw twitter auto-reply --keywords 'support,help' --message 'Thanks for reaching out!'"
    },
    {
      "action": "monitor_mentions",
      "description": "Monitor brand mentions in real-time",
      "command": "openclaw twitter monitor @brandname --alert-webhook https://hooks.example.com"
    },
    {
      "action": "export_analytics",
      "description": "Export tweet analytics",
      "command": "openclaw twitter analytics --days 30 --format csv --output ~/twitter_stats.csv"
    },
    {
      "action": "manage_followers",
      "description": "Follow users based on criteria",
      "command": "openclaw twitter follow --search '#devops' --min-followers 100 --limit 20"
    }
  ],
  "error_handling": {
    "rate_limit_exceeded": "Wait and retry with exponential backoff",
    "authentication_failed": "Check credentials in configuration file",
    "invalid_tweet": "Validate tweet length and media before posting",
    "network_error": "Retry with timeout increase",
    "api_deprecated": "Update to latest API version"
  },
  "best_practices": [
    "Always respect Twitter's rate limits and terms of service",
    "Store API credentials securely in environment variables or encrypted files",
    "Implement proper error handling and logging",
    "Use webhook notifications for important events",
    "Cache frequently accessed data to reduce API calls",
    "Validate tweet content before posting",
    "Monitor API usage to avoid hitting quotas",
    "Implement gradual ramping for automated actions",
    "Add delays between bulk operations to appear more human-like",
    "Regularly backup important tweet data and analytics"
  ],
  "security": {
    "credential_encryption": true,
    "api_key_rotation": "recommended",
    "oauth_token_refresh": "automatic",
    "sensitive_data_filtering": true,
    "audit_logging": true
  }
}
