---
name: twitter-content-generator
description: AI-powered Twitter/X content generator with scheduling and analytics. Generate engaging tweets, threads, and content strategies using Sloan agent.
version: 1.0.1
author: Matt
tags:
  - twitter
  - content-generation
  - social-media
  - ai
pricing:
  type: pay-per-use
  price: 0.002
  currency: USDT
  payment_provider: skillpay.me
---

# Twitter/X Content Generator

Generate engaging Twitter/X content with AI. Perfect for content creators, marketers, and social media managers.

## Features

- **AI Content Generation** - Generate tweets, threads, and content strategies
- **Topic Analysis** - Analyze trending topics and hashtags
- **Scheduling** - Plan and schedule your content
- **Analytics** - Track engagement and optimize

## Usage

```bash
# Generate a tweet
twitter-content-generator "AI trends in 2026" --style engaging

# Generate a thread
twitter-content-generator "How to build AI agents" --type thread --length 5

# Analyze trending topics
twitter-content-generator --trending --niche tech
```

## Pricing

- **Pay per use**: 0.002 USDT per generation
- **Free tier**: 10 free generations

## Configuration

Set your preferences in `config.json`:

```json
{
  "style": "engaging",
  "max_length": 280,
  "include_hashtags": true,
  "include_emojis": true,
  "language": "en"
}
```

## Requirements

- OpenClaw with Sloan agent (AI columnist)
- Twitter/X API credentials (optional for scheduling)
- SkillPay account for payments

## Support

- GitHub: https://github.com/your-username/twitter-content-generator
- Discord: Your Discord server
- Email: your-email@example.com
