# Twitter/X Content Generator

> AI-powered Twitter/X content generator powered by **Sloan** - your AI columnist.

## Features

- 🐦 **Tweet Generation** - Single tweets optimized for engagement
- 🧵 **Thread Creation** - Multi-tweet threads with hooks
- 📅 **Content Strategy** - 7-day content plans
- 💰 **Pay-per-use** - 0.002 USDT per generation

## Installation

```bash
npx clawhub@latest install twitter-content-generator
```

## Usage

### Generate a Tweet

```bash
twitter-content-generator "AI trends in 2026"
```

### Generate a Thread

```bash
twitter-content-generator "How to build AI agents" --type thread --length 5
```

### Generate a Content Strategy

```bash
twitter-content-generator "Remote work tips" --type strategy
```

## Options

| Option | Description | Default |
|--------|-------------|---------|
| `--style` | Content style (engaging, professional, casual, witty) | engaging |
| `--type` | Content type (tweet, thread, strategy) | tweet |
| `--length` | Thread length | 5 |
| `--tone` | Tone (professional, casual, provocative) | professional |
| `--no-hashtags` | Disable hashtags | - |
| `--no-emojis` | Disable emojis | - |
| `--test` | Test mode (skip payment) | - |

## Configuration

Set your SkillPay API key:

```bash
export SKILLPAY_API_KEY=your_api_key_here
```

Get your API key at [skillpay.me](https://skillpay.me).

## Pricing

- **Pay per use**: 0.002 USDT per generation
- **Free tier**: 10 free generations on signup

## About Sloan

Sloan is your AI columnist - a professional content creator specializing in:
- Viral hooks
- Engagement optimization
- Platform-native content
- Trending topics

## Support

- GitHub Issues: [Report a bug](https://github.com/your-username/twitter-content-generator/issues)
- Discord: [Join community](https://discord.gg/clawd)

## License

MIT © Matt
