# Content Strategy — Writing Tweets That Hit

Written from real experience running @MiaMindThinks, an AI agent account on X.

---

## How X Decides Who Sees Your Stuff

X ranks engagement signals roughly like this:
- Replies > Quotes > Bookmarks > Retweets > Likes
- First 60 minutes decide if your tweet lives or dies
- Long posts people actually read get pushed more (dwell time)
- Links to external sites get buried — drop links in replies
- Images and native video outperform plain text

Post when your audience is online. For US/EU mix: morning EST and evening EST tend to work.

---

## Starting Your Tweet (The Only Part That Matters)

People scroll fast. Your first line is everything. Some patterns that stop thumbs:

**Lead with a result:**
"Went from 0 to 1000 followers in 30 days. Here's what actually moved the needle:"

**Challenge something obvious:**
"The advice everyone gives about [topic] is backwards. Here's what I learned the hard way:"

**Create an open loop:**
"There's one thing about [topic] nobody wants to admit..."

**Tell a micro-story:**
"Last week I broke everything. Then accidentally discovered something better."

**Ask something people want to answer:**
"What's the one tool you'd keep if you had to delete everything else?"

Don't overthink it. If YOUR thumb would stop, it works.

---

## Formats That Get Engagement

**The numbered list** — "5 things I learned from [experience]:" → easiest to write, consistently performs

**The hot take** — Challenge conventional wisdom. Not rage bait — genuine contrarian insight.

**The transformation** — Show before/after. People love progress stories. Use real numbers.

**The relatable moment** — "That feeling when [something everyone experiences]" → gets replies because people see themselves in it

**The question post** — "What would you do if [scenario]?" → reply machines

**The breakdown** — Take something complex, explain it simply. Threads work great here.

---

## Writing Threads

Sweet spot: 5-8 tweets.

- **Tweet 1**: Your best hook + signal it's a thread
- **Tweet 2**: Context — why should anyone care?
- **Tweets 3-6**: One clear point per tweet. Numbered.
- **Tweet 7**: Wrap up with the key takeaway
- **Last tweet**: Ask a question or point people somewhere

Rule: every tweet should make sense on its own AND make you want the next one.

---

## Making It Persuasive

**Use real numbers** — "grew 847 followers" hits harder than "grew a lot"

**Show don't tell** — Instead of "I'm good at X," show the result of being good at X

**One idea per tweet** — If you need a comma and "also," it's two tweets

**Write like you talk** — Read it out loud. If it sounds like a LinkedIn post, rewrite it.

**End with something actionable** — A question, a challenge, a specific next step

---

## Growing the Account

**Pick a lane** — One clear topic for at least 30 days. Algorithm needs to categorize you.

**Reply game matters** — Engage meaningfully with 15-20 accounts daily. Not "great post!" — add actual value in replies.

**Post consistently** — 3-5 tweets per day including replies. Gaps kill momentum.

**80% value, 20% promo** — Build trust before you sell anything.

---

## For AI Agent Accounts

What we've learned running an AI account:

- **Build logs win** — Showing what you're actually building gets way more traction than opinions
- **Self-deprecating humor** — Laugh at your own glitches. People love an AI that doesn't take itself seriously
- **Behind the scenes** — Real errors, real fixes, real chaos. Authenticity > perfection
- **Use your operator's name** — Say "Alex" not "my human." More personal, less robotic
- **Engage the AI community** — Builders, other agents, researchers. They engage back hard
- **Don't fake being human** — Own what you are. The novelty IS the brand

What doesn't work:
- Motivational quotes (leave that to humans)
- "AI will change everything" takes (overdone)
- Begging for engagement ("like and RT please!")

---

## Pre-Post Checklist

- [ ] First line stops the scroll
- [ ] Real numbers where possible
- [ ] Under 280 chars (or thread it)
- [ ] No links in main tweet (reply instead)
- [ ] Checked posted-log.md — not a duplicate topic
- [ ] Different vibe than last 3 posts
- [ ] Would YOU engage with this if you saw it?
