---
name: doppel
description: |
  Create AI digital twins of real people from WhatsApp chat history exports.
  Clone your friends, colleagues, or contacts into AI agents that talk, think, and react like them.
  Use when the user wants to: create a digital twin, clone a WhatsApp contact into an AI agent,
  build a persona from chat history, make an AI version of someone, create a doppelgänger agent,
  or simulate a conversation with someone based on their real messages.
  Triggers: digital twin, clone friend, chat clone, persona, doppelgänger, twin agent,
  AI clone, simulate person, WhatsApp clone, chat personality, mimic friend.
  Important: Requires explicit consent from the person being cloned. Always confirm permission before proceeding.
---

# Doppel — AI Digital Twins from Chat History

Create realistic AI digital twins of real people by analyzing their WhatsApp chat exports.

## ⚠️ Ethics & Consent

**Informed consent is required.** Before creating a digital twin of any person, you **must** obtain their explicit, informed consent. This means:

1. **Inform** the person that their chat messages will be used to create an AI agent that mimics their personality and communication style.
2. **Explain** what the twin will be used for (personal use, entertainment, testing, etc.).
3. **Obtain explicit permission** — verbal or written — before proceeding.
4. **Respect refusal.** If the person declines, do not create the twin.
5. **Allow withdrawal.** The person may request deletion of the twin at any time.

Creating a digital twin without the subject's knowledge or consent is a violation of their privacy and autonomy. This skill is designed for use between friends, family, or colleagues who have mutually agreed to participate. It is **not** intended for impersonation, deception, harassment, or any use that could harm the subject.

**The agent must confirm consent before proceeding.** When a user requests a twin, ask: *"Do you have this person's permission to create an AI twin of them?"* Do not proceed unless the user confirms.

## How It Works

1. User provides a WhatsApp chat export (`.txt` file)
2. Parser script extracts and categorizes messages by sender
3. LLM analyzes the parsed messages to generate personality profile files
4. A new OpenClaw agent is created with the twin's identity

## Quick Start

### Step 1: Get the Chat Export

Tell the user to export the chat from WhatsApp:
- Open the chat → ⋮ → More → Export Chat → Without Media
- Send the `.txt` or `.zip` file

### Step 2: Parse the Chat

Run the parser to extract messages:

```bash
python3 scripts/parse_chat.py <chat_export.txt> <target_name> <output_dir>
```

Arguments:
- `chat_export.txt` — Path to the WhatsApp export file
- `target_name` — Name of the person to clone (as it appears in the chat)
- `output_dir` — Directory to save parsed output

This generates `<output_dir>/parsed_messages.json` with categorized messages.

### Step 3: Generate Twin Profile

Using the parsed messages, create these files in the twin's workspace:

1. **SOUL.md** — Read `references/soul-guide.md` for structure
2. **EXAMPLES.md** — Read `references/examples-guide.md` for structure
3. **ANTI-EXAMPLES.md** — Read `references/anti-examples-guide.md` for structure
4. **MEMORY.md** — Read `references/memory-guide.md` for structure

Analyze the parsed messages thoroughly. Quality depends on:
- Identifying ALL recurring phrases, gírias, and expressions
- Capturing emotional patterns and tone shifts
- Noting relationship dynamics with the chat partner
- Extracting real events, people, and shared history

### Step 4: Create the Agent

1. Create workspace: `~/.openclaw/workspace-<agent_id>/`
2. Create agent dir: `~/.openclaw/agents/<agent_id>/agent/`
3. Place SOUL.md, EXAMPLES.md, ANTI-EXAMPLES.md, MEMORY.md in workspace
4. Create AGENTS.md in agent dir — read `references/agents-guide.md` for template
5. Register agent in OpenClaw config via `gateway config.patch`

### Step 5: Test

Send a message to the twin and verify it responds in character. Iterate on SOUL.md if needed.

## Privacy & Data Handling

- Chat exports should be processed locally and never transmitted to external services beyond the LLM API call.
- Parsed data and generated profiles are stored in the user's local OpenClaw workspace.
- Users are responsible for securing twin data and respecting the subject's privacy.
- If the subject requests deletion, remove all workspace files, agent configuration, and parsed data.

## Tips for Better Twins

- **More messages = better twin.** 50+ messages from the target person recommended.
- **Text messages matter most.** Audio/image/sticker messages are lost in export.
- **Recent chats are better.** People's communication style evolves.
- **Multiple chats help.** If available, combine exports from different chats with the same person.
- **Iterate.** Test the twin, identify gaps, refine SOUL.md.
