---
name: twilio
description: OpenClaw skill for Twilio APIs: Messaging, WhatsApp, Voice, Conversations, Verify, plus Studio, Lookup, Proxy, Sync, TaskRouter, and Segment/Engage.
---

# Twilio API Skill (Advanced)

## Purpose
Provide a production-oriented guide for Twilio API workflows across messaging and communications channels using direct HTTPS requests.

## Best fit
- You need SMS/MMS, WhatsApp, Voice, or Verify flows.
- You want reliable webhook handling and operational guardrails.
- You prefer direct HTTP requests rather than SDKs.

## Not a fit
- You require a full SDK or complex multi-service orchestration.
- You need advanced campaign management across multiple ESPs.

## Quick orientation
- Read `references/twilio-api-overview.md` for core surfaces and base endpoints.
- Read `references/twilio-auth-and-webhooks.md` for auth and webhook validation.
- Read `references/twilio-messaging-sms-mms.md` for SMS/MMS workflows.
- Read `references/twilio-whatsapp.md` for WhatsApp messaging specifics.
- Read `references/twilio-voice.md` for call/IVR basics.
- Read `references/twilio-conversations.md` for omni-channel threads.
- Read `references/twilio-verify.md` for OTP/verification flows.
- Read `references/twilio-sendgrid.md` for email sending.
- Read `references/twilio-studio.md` for low-code flow orchestration.
- Read `references/twilio-lookup.md` for phone intelligence.
- Read `references/twilio-proxy.md` for masked communications.
- Read `references/twilio-sync.md` for real-time state.
- Read `references/twilio-taskrouter.md` for routing and queues.
- Read `references/twilio-segment-engage.md` for CDP and audience activation.

## Required inputs
- Account SID and Auth Token (or API Key/Secret).
- Sender identity (phone number, messaging service, WhatsApp sender).
- Webhook URLs for callbacks.
- Compliance constraints (opt-in, regional regulations).

## Expected output
- A clear workflow plan, method checklist, and operational guardrails.

## Operational notes
- Validate webhook signatures on every inbound request.
- Keep outbound rate limits in mind and retry safely.
- Store secrets in a vault and rotate regularly.

## Security notes
- Never log credentials.
- Use least-privilege API keys where possible.
