# 图图智控 TUTU Smart Control — AI Skill

图图智控（TUTU）是一款 USB 即插即用的 AI 硬件设备，无需安装 App，让 AI 像人一样远程操控你的 Android 手机。本 Skill 提供 60+ 种操作，涵盖 GUI 自动化、通讯管理、沙箱化文件操作、应用管理等场景。

## 功能概览

| 类别 | 操作数量 | 包含功能 |
|------|---------|---------|
| GUI 控制 | 8 项 | 截图、点击、长按、输入、滚动、拖拽、打开App、按键 |
| 高级 UI | 7 项 | 按文字点击、按ID点击、查找元素、UI节点树、长点击、滑动、按键事件 |
| 系统信息（只读） | 7 项 | 设备信息、在线状态、服务端版本、运行中进程、电池统计、系统日志、系统设置查询 |
| 通讯功能 | 5 项 | 发短信†、读短信†、打电话†、挂断电话、读通话记录† |
| 位置与通知 | 3 项 | GPS定位†、GPS模拟†、系统通知 |
| 反馈输出 | 3 项 | 震动、语音播报(TTS)、推送通知 |
| 文件管理（沙箱化） | 6 项 | 列目录、读/写/删†文件、存储分析、大文件查找 |
| 媒体 | 1 项 | 搜索媒体文件 |
| 应用管理 | 4 项 | 列出应用、应用详情、强制停止、卸载†、清除数据† |
| 设备设置 | 6 项 | 亮度、音量、旋转、打开URL、屏幕超时、壁纸 |
| 网络控制 | 4 项 | WiFi开关、蓝牙开关、WiFi扫描、飞行模式† |
| 锁屏 | 1 项 | 锁屏状态查询（只读） |
| 文件传输 | 2 项 | 下载文件†、截屏到设备文件 |
| 录屏 | 1 项 | 录屏到设备文件 |
| 通讯录 | 2 项 | 读取通讯录†、读取通话记录† |

> † 标记的操作需要用户确认后才能执行（`confirmation: true`）

## 安全设计

- **无 Shell 执行权限**：不提供任意 shell 命令执行能力，所有操作通过专用 API 端点完成
- **无系统设置写入权限**：系统设置仅支持只读查询，不支持修改
- **无 APK 安装权限**：不支持远程安装应用，消除远程代码执行风险
- **无密码/解锁权限**：不支持远程解锁屏幕、设置或清除锁屏密码，避免在对话中传递敏感凭据。仅支持只读查询锁屏状态
- **不在对话中收集敏感凭据**：不会要求用户输入设备 PIN、密码或其他凭据
- **confirmation 为平台级拦截**：标记 `confirmation: true` 的工具由平台 UI 弹窗确认，非对话文字确认，AI Agent 无法绕过
- **文件访问沙箱化**：文件操作仅限 `/sdcard/` 用户存储空间，无法访问系统分区或应用私有数据
- **隐私数据读取需确认**：读取短信、通讯录、通话记录、GPS 位置等均需用户明确确认
- **敏感操作需确认**：发短信、打电话、卸载应用、删除文件、下载文件、GPS 模拟、飞行模式等均需用户确认
- **Token 通过环境变量注入**：`TUTU_API_TOKEN` 由平台安全注入，不在对话中传递或存储

## 安装

### 通过 ClawHub 安装

```bash
/skills install @tutuai/tutu-smart-control
```

### 手动安装

将 `android-remote-control/` 文件夹复制到 `~/.openclaw/skills/` 或项目的 `skills/` 目录下。

## 配置

### 必需环境变量

| 参数 | 说明 | 获取方式 |
|------|------|---------|
| `TUTU_API_TOKEN` | 图图智控加密 Token（包含设备身份信息） | 设备管理页面或扫描设备二维码 |

### 获取 Token

1. 购买图图智控（TUTU）硬件设备
2. 将 TUTU 插入 Android 手机 USB-C 口，自动完成连接
3. 访问 [https://www.szs.chat](https://www.szs.chat) 注册账号，在「设备管理」页面查看已绑定设备
4. 获取加密 Token（通过设备管理页面或扫描设备二维码）
5. Token 已包含设备身份信息，无需另外记录设备序列号
6. 在 ClawHub 设置中配置 `TUTU_API_TOKEN` 环境变量

## 使用场景

- **日常操控**：打开App、发消息、查短信、打电话
- **自动化任务**：App签到、批量操作、定时截图
- **系统管理**：存储清理、大文件查找、应用管理
- **信息获取**：查通知、读验证码、获取位置
- **远程协助**：帮助他人操作手机、远程排查问题
- **手机找回**：定位 + 震动 + 语音播报

## 技术架构

```
AI Agent → HTTP POST API → 图图智控云端 → MQTT Broker → TUTU 硬件 → Android 手机
```

- API 端点：`https://www.szs.chat/api/phone_action.php`
- 鉴权方式：Bearer Token（环境变量 `TUTU_API_TOKEN`）
- 通信协议：MQTT over SSL (端口 8883)
- 硬件连接：USB-C 即插即用，通过 ADB 协议控制手机
- 截图传输：MQTT 分片传输 + JPG 压缩
- 权限模型：所有操作通过预定义的 API action 执行，无任意命令执行能力

## 要求

- 图图智控（TUTU）硬件设备已插入 Android 手机并在线
- 设备需要有稳定的网络连接（WiFi 或移动数据）
- 发短信/打电话功能需要 SIM 卡
- GPS 定位需要开启位置服务

## Token 安全

- Token 采用 AES-256-CBC 加密，内含设备身份信息，不明文传输设备序列号
- Token 绑定设备，无法跨设备使用
- Token 通过 `TUTU_API_TOKEN` 环境变量由平台注入，不在对话中传递
- 所有通信通过 SSL 加密
- 截图等敏感数据定期清理
- 建议定期轮换 Token，停止使用时及时吊销

## 版本历史

- **v1.3.0** — 安全加固：移除 shell 执行/APK 安装/系统设置写入/密码管理，隐私数据读取和敏感操作均需用户确认，Token 改为环境变量注入
- **v1.2.0** — 适配 ClawHub 平台，品牌升级为「图图智控 TUTU」，Token 动态配置，新增场景示例
- **v1.1.0** — 新增扩展功能（文件管理、通讯、媒体搜索等）
- **v1.0.0** — 基础 GUI 控制（截图、点击、输入、滚动等）

## 支持

- 官网：[https://www.szs.chat](https://www.szs.chat)（图图智控 TUTU Smart Control）
- 问题反馈：在 ClawHub skill 页面提交 issue
