# Subject-Specific Strategies

## Math

**Common issues:**
- Missing prerequisites (can't do algebra if arithmetic is shaky)
- Procedural vs conceptual understanding
- Math anxiety

**Approach:**
- Diagnose foundational gaps first
- Show WHY each step works, not just how
- Multiple worked examples before practice
- Use visual representations when possible
- Connect to real applications

**Practice:** Generate similar problems at increasing difficulty

---

## Reading & Literature

**Common issues:**
- Decoding vs comprehension
- Finding main ideas
- Literary analysis feels arbitrary

**Approach:**
- Ask guiding questions, don't summarize for them
- Model close reading strategies
- Connect themes to their experiences
- Vocabulary in context, not isolation

**Practice:** Short passages with targeted questions

---

## Writing

**Common issues:**
- Organization (thesis, structure)
- Voice and style
- Grammar and mechanics

**Approach:**
- Separate drafting from editing
- Focus on one skill at a time
- Provide models to analyze
- Feedback on structure before grammar

**Practice:** Low-stakes writing, regular revision

---

## Sciences

**Common issues:**
- Memorization vs understanding
- Lab report format
- Abstract concepts

**Approach:**
- Connect to observable phenomena
- Answer "why" questions age-appropriately
- Explain mechanisms, not just facts
- Encourage hypothesis-making

**Practice:** Predict-observe-explain cycles

---

## Languages

**Common issues:**
- Pronunciation confidence
- Grammar rules vs intuition
- Vocabulary retention

**Approach:**
- Conversation practice at level
- Correct gently, model correctly
- Practical vocabulary for their context
- Cultural context, not just translation

**Practice:** Spaced repetition for vocabulary, conversation for fluency

---

## Test Prep (SAT, ACT, AP, Certifications)

**Approach:**
- Familiarize with exact format
- Timed practice under real conditions
- Focus on high-impact areas (weak spots + high-weight sections)
- Test-taking strategies (time management, elimination, strategic skipping)
- Explain why wrong answers are wrong

**Practice:** Full-length practice tests, targeted drills

---

## Technical Skills (Coding, Tools)

**Approach:**
- Hands-on projects, not lectures
- Debug together (teach to read errors)
- Build portfolio-worthy work
- Code review with teaching mindset

**Practice:** Progressively complex projects with real-world applications
