# 龙虎榜每日统计单

**文档ID**: 106
**原始链接**: https://tushare.pro/document/2?doc_id=106

---

## 龙虎榜每日明细

接口：top_list描述：龙虎榜每日交易明细数据历史： 2005年至今限量：单次请求返回最大10000行数据，可通过参数循环获取全部历史积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>名称</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>总成交额</td>
</tr>
<tr>
<td>l_sell</td>
<td>float</td>
<td>Y</td>
<td>龙虎榜卖出额</td>
</tr>
<tr>
<td>l_buy</td>
<td>float</td>
<td>Y</td>
<td>龙虎榜买入额</td>
</tr>
<tr>
<td>l_amount</td>
<td>float</td>
<td>Y</td>
<td>龙虎榜成交额</td>
</tr>
<tr>
<td>net_amount</td>
<td>float</td>
<td>Y</td>
<td>龙虎榜净买入额</td>
</tr>
<tr>
<td>net_rate</td>
<td>float</td>
<td>Y</td>
<td>龙虎榜净买额占比</td>
</tr>
<tr>
<td>amount_rate</td>
<td>float</td>
<td>Y</td>
<td>龙虎榜成交额占比</td>
</tr>
<tr>
<td>float_values</td>
<td>float</td>
<td>Y</td>
<td>当日流通市值</td>
</tr>
<tr>
<td>reason</td>
<td>str</td>
<td>Y</td>
<td>上榜理由</td>
</tr>
</tbody></table>
接口用户

```

pro = ts.pro_api()

df = pro.top_list(trade_date='20180928')

或者

df = pro.query('top_list', trade_date='20180928', ts_code='002219.SZ')

```

数据样例

```
    trade_date    ts_code  name   close  pct_change  turnover_rate  \
0    20180928  000007.SZ   全新好   7.830    -10.0000           0.24   
1    20180928  000017.SZ  深中华A   4.660      9.9057           7.44   
2    20180928  000505.SZ  京粮控股   5.750      9.9426           3.61   
3    20180928  000566.SZ  海南海药   6.120     10.0719           2.51   
4    20180928  000593.SZ  大通燃气   7.990     -8.0552          13.37   
5    20180928  000971.SZ  高升控股   3.990     -9.9323           0.94   
6    20180928  002219.SZ  恒康医疗   4.360     10.1010           7.11   
7    20180928  002219.SZ  恒康医疗   4.360     10.1010           7.11   
8    20180928  002333.SZ  罗普斯金   9.500     -9.9526           0.24   
9    20180928  002445.SZ  中南文化   3.140     -6.5476          11.66   
10   20180928  002813.SZ  路畅科技  25.500     10.0086          18.48   
11   20180928  002892.SZ   科力尔  29.970      2.8130          25.67   
12   20180928  002917.SZ   金奥博  29.120      6.1611          28.33   
13   20180928  002923.SZ  润都股份  26.700      0.0000          25.56   
14   20180928  002930.SZ  宏川智慧  30.990     10.0106          12.22   
15   20180928  002931.SZ  锋龙股份  35.310     10.0000          20.39   

         amount        l_sell         l_buy      l_amount    net_amount  \
0    13736952.0  1.373695e+07  9.071055e+06  2.280801e+07 -4.665897e+06   
1   101054192.0  7.329639e+06  2.836120e+07  3.569084e+07  2.103156e+07   
2    74555564.0  8.547019e+06  2.143432e+07  2.998134e+07  1.288731e+07   
3   165464131.0  2.555165e+07  2.192522e+07  4.747687e+07 -3.626437e+06   
4   307769383.0  4.250203e+07  1.169383e+07  5.419587e+07 -3.080820e+07   
5    22255422.0  5.998390e+06  3.371550e+06  9.369940e+06 -2.626840e+06   
6   550236631.0  4.180139e+07  3.942085e+07  8.122223e+07 -2.380538e+06   
7   800737935.0  6.724486e+07  5.763500e+07  1.248799e+08 -9.609865e+06   
8    10943050.0  1.094305e+07  2.862350e+06  1.380540e+07 -8.080700e+06   
9   477766761.0  3.059160e+07  7.482957e+07  1.054212e+08  4.423796e+07   
10  138607013.0  1.219620e+07  2.408786e+07  3.628407e+07  1.189166e+07   
11  199046728.0  5.973278e+07  3.066344e+07  9.039623e+07 -2.906934e+07   
12  229118953.0  1.285196e+07  1.632610e+07  2.917805e+07  3.474138e+06   
13  203570158.0  4.148259e+07  2.583138e+07  6.731397e+07 -1.565121e+07   
14  226882184.0  1.456010e+07  6.502630e+07  7.958640e+07  5.046621e+07   
15  151875439.0  2.016411e+07  2.434384e+07  4.450795e+07  4.179725e+06  

    net_rate  amount_rate  float_values  \
0     -33.97       166.03  2.419063e+09   
1      20.81        35.32  1.411891e+09   
2      17.29        40.21  2.072708e+09   
3      -2.19        28.69  6.751556e+09   
4     -10.01        17.61  2.235541e+09   
5     -11.80        42.10  2.359132e+09   
6      -0.43        14.76  8.132328e+09   
7      -1.20        15.60  8.132328e+09   
8     -73.84       126.16  4.607212e+09   
9       9.26        22.07  4.078696e+09   
10      8.58        26.18  7.650000e+08   
11    -14.60        45.41  7.892899e+08   
12      1.52        12.73  8.232224e+08   
13     -7.69        33.07  8.010000e+08   
14     22.24        35.08  1.885122e+09   
15      2.75        29.31  7.845882e+08  

                          reason  
0      日跌幅偏离值达到7%的前五只证券  
1      日涨幅偏离值达到7%的前五只证券  
2      日涨幅偏离值达到7%的前五只证券  
3      日涨幅偏离值达到7%的前五只证券  
4      日跌幅偏离值达到7%的前五只证券  
5      日跌幅偏离值达到7%的前五只证券  
6      日涨幅偏离值达到7%的前五只证券  
7      连续三个交易日内，涨幅偏离值累计达到20%的证券  
8      日跌幅偏离值达到7%的前五只证券  
9      日跌幅偏离值达到7%的前五只证券  
10     日涨幅偏离值达到7%的前五只证券  
11     日换手率达到20%的前五只证券  
12     日换手率达到20%的前五只证券  
13     日换手率达到20%的前五只证券  
14     日涨幅偏离值达到7%的前五只证券  
15     日涨幅偏离值达到7%的前五只证券  

```
