# 龙虎榜机构交易单

**文档ID**: 107
**原始链接**: https://tushare.pro/document/2?doc_id=107

---

## 龙虎榜机构明细

接口：top_inst描述：龙虎榜机构成交明细限量：单次请求最大返回10000行数据，可根据参数循环获取全部历史积分：用户需要至少5000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>exalter</td>
<td>str</td>
<td>Y</td>
<td>营业部名称</td>
</tr>
<tr>
<td>side</td>
<td>str</td>
<td>Y</td>
<td>买卖类型0：买入金额最大的前5名， 1：卖出金额最大的前5名</td>
</tr>
<tr>
<td>buy</td>
<td>float</td>
<td>Y</td>
<td>买入额（元）</td>
</tr>
<tr>
<td>buy_rate</td>
<td>float</td>
<td>Y</td>
<td>买入占总成交比例</td>
</tr>
<tr>
<td>sell</td>
<td>float</td>
<td>Y</td>
<td>卖出额（元）</td>
</tr>
<tr>
<td>sell_rate</td>
<td>float</td>
<td>Y</td>
<td>卖出占总成交比例</td>
</tr>
<tr>
<td>net_buy</td>
<td>float</td>
<td>Y</td>
<td>净成交额（元）</td>
</tr>
<tr>
<td>reason</td>
<td>str</td>
<td>Y</td>
<td>上榜理由</td>
</tr>
</tbody></table>
接口用法

```
pro = ts.pro_api()

df = pro.top_inst(trade_date='20210525')

或者

df = pro.query('top_inst', trade_date='20210524', ts_code='000592.SZ', fileds='trade_date,buy,sell,side,reason')

```

```
   trade_date          buy         sell side                   reason
0    20210524  19627524.05  25593683.67    0              涨幅偏离值达7%的证券
1    20210524   9091252.00  18009704.00    0              涨幅偏离值达7%的证券
2    20210524  35168640.99  13344062.12    0              涨幅偏离值达7%的证券
3    20210524  18812912.60  12121352.00    0              涨幅偏离值达7%的证券
4    20210524   1684986.00  12076417.00    0              涨幅偏离值达7%的证券
5    20210524  37071259.81   3956982.00    1              涨幅偏离值达7%的证券
6    20210524  35168640.99  13344062.12    1              涨幅偏离值达7%的证券
7    20210524  21487772.44     84795.00    1              涨幅偏离值达7%的证券
8    20210524  19627524.05  25593683.67    1              涨幅偏离值达7%的证券
9    20210524  18812912.60  12121352.00    1              涨幅偏离值达7%的证券
10   20210524  28720777.05  53009929.06    0  连续三个交易日内，涨幅偏离值累计达20%的证券
11   20210524  35504648.99  46382533.92    0  连续三个交易日内，涨幅偏离值累计达20%的证券
12   20210524  35344119.44  46305551.88    0  连续三个交易日内，涨幅偏离值累计达20%的证券
13   20210524   9091252.00  26481086.00    0  连续三个交易日内，涨幅偏离值累计达20%的证券
14   20210524  23609443.87  23791701.41    0  连续三个交易日内，涨幅偏离值累计达20%的证券
15   20210524  49699663.21   3956982.00    1  连续三个交易日内，涨幅偏离值累计达20%的证券
16   20210524  35504648.99  46382533.92    1  连续三个交易日内，涨幅偏离值累计达20%的证券
17   20210524  35344119.44  46305551.88    1  连续三个交易日内，涨幅偏离值累计达20%的证券
18   20210524  29607924.52  19374138.00    1  连续三个交易日内，涨幅偏离值累计达20%的证券
19   20210524  28720777.05  53009929.06    1  连续三个交易日内，涨幅偏离值累计达20%的证券

```
