# 题材数据（开盘啦）

**文档ID**: 350
**原始链接**: https://tushare.pro/document/2?doc_id=350

---

## 开盘啦题材库

接口：kpl_concept描述：获取开盘啦概念题材列表，每天盘后更新限量：单次最大5000条，可根据日期循环获取历史数据积分：5000积分可提取数据，具体请参阅积分获取办法

注：开盘啦是一个优秀的专业打板app，有兴趣的用户可以自行下载安装。本接口仅限用于量化研究，如需商业用途，请自行联系开盘APP官方。此接口因源站改版暂无新增数据

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>题材代码（xxxxxx.KP格式）</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>题材名称</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>题材代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>题材名称</td>
</tr>
<tr>
<td>z_t_num</td>
<td>None</td>
<td>Y</td>
<td>涨停数量</td>
</tr>
<tr>
<td>up_num</td>
<td>str</td>
<td>Y</td>
<td>排名上升位数</td>
</tr>
</tbody>
</table>
接口用法

```
pro = ts.pro_api()

df = pro.kpl_concept(trade_date='20241014')

```

数据样例

```
    trade_date    ts_code     name      z_t_num up_num
0     20241014  000111.KP     化债概念       15      0
1     20241014  000262.KP     跨境支付        2      0
2     20241014  000039.KP     华为鸿蒙        8      0
3     20241014  000259.KP   墨脱水电概念        3     68
4     20241014  000276.KP   神经网络概念        1      0
..         ...        ...      ...      ...    ...
160   20241014  000267.KP     乙游概念        0      0
161   20241014  000203.KP      碳纤维        0      0
162   20241014  000167.KP   冷锻工艺概念        0      0
163   20241014  000059.KP    一体化压铸        0      0
164   20241014  000266.KP  集换式卡牌概念        0      0

```
