# 限售股解禁

**文档ID**: 160
**原始链接**: https://tushare.pro/document/2?doc_id=160

---

## 限售股解禁

接口：share_float描述：获取限售股解禁限量：单次最大6000条，总量不限制积分：120分可调取，每分钟内限制次数，超过5000积分频次相对较高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期（日期格式：YYYYMMDD，下同）</td>
</tr>
<tr>
<td>float_date</td>
<td>str</td>
<td>N</td>
<td>解禁日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>解禁开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>解禁结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>float_date</td>
<td>str</td>
<td>Y</td>
<td>解禁日期</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股份(股)</td>
</tr>
<tr>
<td>float_ratio</td>
<td>float</td>
<td>Y</td>
<td>流通股份占总股本比率</td>
</tr>
<tr>
<td>holder_name</td>
<td>str</td>
<td>Y</td>
<td>股东名称</td>
</tr>
<tr>
<td>share_type</td>
<td>str</td>
<td>Y</td>
<td>股份类型</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

df = pro.share_float(ann_date='20181220')

```

数据示例

```
    ts_code    ann_date float_date  float_share  float_ratio         holder_name  \
0   000998.SZ  20181220   20211221   25076106.0       1.9041              王义波   
1   000998.SZ  20181220   20211221   11265340.0       0.8554              彭泽斌   
2   000998.SZ  20181220   20211221   10820446.0       0.8216               杨蔚   
3   000998.SZ  20181220   20211221    2704317.0       0.2053               王宏   
4   000998.SZ  20181220   20211221    2704317.0       0.2053              姜书贤   
5   000998.SZ  20181220   20211221    2952186.0       0.2242              谢玉迁   
6   000998.SZ  20181220   20211221    3022098.0       0.2295              陆利行   
7   000998.SZ  20181220   20211221     190668.0       0.0145              史泽琪   
8   000998.SZ  20181220   20211221     190668.0       0.0145               张林   
9   000998.SZ  20181220   20211221      95334.0       0.0072              孙继明   
10  000998.SZ  20181220   20211221      95334.0       0.0072              王青才   
11  000998.SZ  20181220   20211221      95334.0       0.0072               刘榜   
12  000998.SZ  20181220   20211221      63556.0       0.0048               朱静   
13  000998.SZ  20181220   20211221      63556.0       0.0048              陈亮亮   
14  000998.SZ  20181220   20211221      63556.0       0.0048              杜培林   
15  000998.SZ  20181220   20211221      63556.0       0.0048               高飞   
16  000998.SZ  20181220   20211221      63556.0       0.0048              胡素华   
17  000998.SZ  20181220   20211221      63556.0       0.0048              王明磊   
18  000998.SZ  20181220   20211221      63556.0       0.0048              刘占才   
19  000998.SZ  20181220   20211221      63556.0       0.0048              傅兆作   
20  000998.SZ  20181220   20211221      63556.0       0.0048              应银链   

     share_type  
0        定增股份  
1        定增股份  
2        定增股份  
3        定增股份  
4        定增股份  
5        定增股份  
6        定增股份  
7        定增股份  
8        定增股份  
9        定增股份  
10       定增股份  
11       定增股份  
12       定增股份  
13       定增股份  
14       定增股份  
15       定增股份  
16       定增股份  
17       定增股份  
18       定增股份  
19       定增股份  
20       定增股份  

```
