# 销售机构公募基金销售保有规模

**文档ID**: 266
**原始链接**: https://tushare.pro/document/2?doc_id=266

---

## 销售机构公募基金销售保有规模

接口：fund_sales_vol描述：获取销售机构公募基金销售保有规模数据，本数据从2021年Q1开始公布，季度更新限量：单次最大500行数据，目前总量只有100行，未来随着数据量增加会提高上限

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>year</td>
<td>str</td>
<td>N</td>
<td>年度</td>
</tr>
<tr>
<td>quarter</td>
<td>str</td>
<td>N</td>
<td>季度</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>机构名称</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>year</td>
<td>int</td>
<td>Y</td>
<td>年度</td>
</tr>
<tr>
<td>quarter</td>
<td>str</td>
<td>Y</td>
<td>季度</td>
</tr>
<tr>
<td>inst_name</td>
<td>str</td>
<td>Y</td>
<td>销售机构</td>
</tr>
<tr>
<td>fund_scale</td>
<td>float</td>
<td>Y</td>
<td>股票+混合公募基金保有规模（亿元）</td>
</tr>
<tr>
<td>scale</td>
<td>float</td>
<td>Y</td>
<td>非货币市场公募基金保有规模（亿元）</td>
</tr>
<tr>
<td>rank</td>
<td>int</td>
<td>Y</td>
<td>排名</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.fund_sales_vol()


```

数据示例

```
     year quarter         inst_name           fund_scale   scale  rank
0   2021      Q1        招商银行股份有限公司    6711.00  7079.00     1
1   2021      Q1    蚂蚁（杭州）基金销售有限公司    5719.00  8901.00     2
2   2021      Q1      中国工商银行股份有限公司    4992.00  5366.00     3
3   2021      Q1      中国建设银行股份有限公司    3794.00  4101.00     4
4   2021      Q1      上海天天基金销售有限公司    3750.00  4324.00     5
..   ...     ...               ...        ...      ...   ...
95  2021      Q1        万联证券股份有限公司      22.00    23.00    96
96  2021      Q1     北京度小满基金销售有限公司      22.00    29.00    97
97  2021      Q1        大同证券有限责任公司      22.00    25.00    98
98  2021      Q1  宜信普泽（北京）基金销售有限公司      21.00    36.00    99
99  2021      Q1      恒生银行（中国）有限公司      20.00    22.00   100

[100 rows x 6 columns]
```

注：

1、股票+混合公募基金保有规模精确至0.01亿元进行排序。

2、表中所述“保有规模”包括各类投资者通过基金代销机构认申购公募基金（含交易所场内基金）及已参公规范的券商大集合产品形成的保有规模。
