# 采购经理指数（PMI）

**文档ID**: 325
**原始链接**: https://tushare.pro/document/2?doc_id=325

---

## 采购经理人指数

接口：cn_pmi描述：采购经理人指数限量：单次最大2000，一次可以提取全部数据权限：用户积累2000积分可以使用，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>m</td>
<td>str</td>
<td>N</td>
<td>月度（202401表示，2024年1月）</td>
</tr>
<tr>
<td>start_m</td>
<td>str</td>
<td>N</td>
<td>开始月度</td>
</tr>
<tr>
<td>end_m</td>
<td>str</td>
<td>N</td>
<td>结束月度（e.g. fields='month,pmi010000,pmi010400'）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>month</td>
<td>str</td>
<td>N</td>
<td>月份YYYYMM</td>
</tr>
<tr>
<td>pmi010000</td>
<td>float</td>
<td>N</td>
<td>制造业PMI</td>
</tr>
<tr>
<td>pmi010100</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:企业规模/大型企业</td>
</tr>
<tr>
<td>pmi010200</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:企业规模/中型企业</td>
</tr>
<tr>
<td>pmi010300</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:企业规模/小型企业</td>
</tr>
<tr>
<td>pmi010400</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/生产指数</td>
</tr>
<tr>
<td>pmi010401</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/生产指数:企业规模/大型企业</td>
</tr>
<tr>
<td>pmi010402</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/生产指数:企业规模/中型企业</td>
</tr>
<tr>
<td>pmi010403</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/生产指数:企业规模/小型企业</td>
</tr>
<tr>
<td>pmi010500</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/新订单指数</td>
</tr>
<tr>
<td>pmi010501</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/新订单指数:企业规模/大型企业</td>
</tr>
<tr>
<td>pmi010502</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/新订单指数:企业规模/中型企业</td>
</tr>
<tr>
<td>pmi010503</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/新订单指数:企业规模/小型企业</td>
</tr>
<tr>
<td>pmi010600</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/供应商配送时间指数</td>
</tr>
<tr>
<td>pmi010601</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/供应商配送时间指数:企业规模/大型企业</td>
</tr>
<tr>
<td>pmi010602</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/供应商配送时间指数:企业规模/中型企业</td>
</tr>
<tr>
<td>pmi010603</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/供应商配送时间指数:企业规模/小型企业</td>
</tr>
<tr>
<td>pmi010700</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/原材料库存指数</td>
</tr>
<tr>
<td>pmi010701</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/原材料库存指数:企业规模/大型企业</td>
</tr>
<tr>
<td>pmi010702</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/原材料库存指数:企业规模/中型企业</td>
</tr>
<tr>
<td>pmi010703</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/原材料库存指数:企业规模/小型企业</td>
</tr>
<tr>
<td>pmi010800</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/从业人员指数</td>
</tr>
<tr>
<td>pmi010801</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/从业人员指数:企业规模/大型企业</td>
</tr>
<tr>
<td>pmi010802</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/从业人员指数:企业规模/中型企业</td>
</tr>
<tr>
<td>pmi010803</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:构成指数/从业人员指数:企业规模/小型企业</td>
</tr>
<tr>
<td>pmi010900</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/新出口订单</td>
</tr>
<tr>
<td>pmi011000</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/进口</td>
</tr>
<tr>
<td>pmi011100</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/采购量</td>
</tr>
<tr>
<td>pmi011200</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/主要原材料购进价格</td>
</tr>
<tr>
<td>pmi011300</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/出厂价格</td>
</tr>
<tr>
<td>pmi011400</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/产成品库存</td>
</tr>
<tr>
<td>pmi011500</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/在手订单</td>
</tr>
<tr>
<td>pmi011600</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:其他/生产经营活动预期</td>
</tr>
<tr>
<td>pmi011700</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:分行业/装备制造业</td>
</tr>
<tr>
<td>pmi011800</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:分行业/高技术制造业</td>
</tr>
<tr>
<td>pmi011900</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:分行业/基础原材料制造业</td>
</tr>
<tr>
<td>pmi012000</td>
<td>float</td>
<td>N</td>
<td>制造业PMI:分行业/消费品制造业</td>
</tr>
<tr>
<td>pmi020100</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:商务活动</td>
</tr>
<tr>
<td>pmi020101</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:商务活动:分行业/建筑业</td>
</tr>
<tr>
<td>pmi020102</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:商务活动:分行业/服务业业</td>
</tr>
<tr>
<td>pmi020200</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:新订单指数</td>
</tr>
<tr>
<td>pmi020201</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:新订单指数:分行业/建筑业</td>
</tr>
<tr>
<td>pmi020202</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:新订单指数:分行业/服务业</td>
</tr>
<tr>
<td>pmi020300</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:投入品价格指数</td>
</tr>
<tr>
<td>pmi020301</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:投入品价格指数:分行业/建筑业</td>
</tr>
<tr>
<td>pmi020302</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:投入品价格指数:分行业/服务业</td>
</tr>
<tr>
<td>pmi020400</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:销售价格指数</td>
</tr>
<tr>
<td>pmi020401</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:销售价格指数:分行业/建筑业</td>
</tr>
<tr>
<td>pmi020402</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:销售价格指数:分行业/服务业</td>
</tr>
<tr>
<td>pmi020500</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:从业人员指数</td>
</tr>
<tr>
<td>pmi020501</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:从业人员指数:分行业/建筑业</td>
</tr>
<tr>
<td>pmi020502</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:从业人员指数:分行业/服务业</td>
</tr>
<tr>
<td>pmi020600</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:业务活动预期指数</td>
</tr>
<tr>
<td>pmi020601</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:业务活动预期指数:分行业/建筑业</td>
</tr>
<tr>
<td>pmi020602</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:业务活动预期指数:分行业/服务业</td>
</tr>
<tr>
<td>pmi020700</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:新出口订单</td>
</tr>
<tr>
<td>pmi020800</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:在手订单</td>
</tr>
<tr>
<td>pmi020900</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:存货</td>
</tr>
<tr>
<td>pmi021000</td>
<td>float</td>
<td>N</td>
<td>非制造业PMI:供应商配送时间</td>
</tr>
<tr>
<td>pmi030000</td>
<td>float</td>
<td>N</td>
<td>中国综合PMI:产出指数</td>
</tr>
</tbody></table>
接口调用

```
pro = ts.pro_api()

#获取指定字段
df = pro.cn_pmi(start_m='201901', end_m='202003', fields='month,pmi010000,pmi010400')

```

数据样例

```
        month pmi010000 pmi010100 pmi010200 pmi010300 pmi010400 pmi010401 pmi010402
0   202403     50.80     51.10     50.60     50.30     52.20     52.70     51.50
1   202402     49.10     50.40     49.10     46.40     49.80     51.20     49.60
2   202401     49.20     50.40     48.90     47.20     51.30     52.30     52.40
3   202312     49.00     50.00     48.70     47.30     50.20     51.50     50.10
4   202311     49.40     50.50     48.80     47.80     50.70     52.10     50.50
5   202310     49.50     50.70     48.70     47.90     50.90     53.10     49.00
6   202309     50.20     51.60     49.60     48.00     52.70     54.40     52.40
7   202308     49.70     50.80     49.60     47.70     51.90     53.70     51.60
8   202307     49.30     50.30     49.00     47.40     50.20     52.00     49.50
9   202306     49.00     50.30     48.90     46.40     50.30     52.70     50.20
10  202305     48.80     50.00     47.60     47.90     49.60     51.50     48.00
11  202304     49.20     49.30     49.20     49.00     50.20     50.10     49.80
12  202303     51.90     53.60     50.30     50.40     54.60     57.20     52.60
13  202302     52.60     53.70     52.00     51.20     56.70     58.20     56.60
14  202301     50.10     52.30     48.60     47.20     49.80     53.10     47.20

```
