# 通达信板块行情

**文档ID**: 378
**原始链接**: https://tushare.pro/document/2?doc_id=378

---

## 通达信板块行情

接口：tdx_daily描述：获取通达信各板块行情，包括成交和估值等数据限量：单次提取最大3000条数据，可根据板块代码和日期参数循环提取权限：用户积累6000积分可调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>板块代码：xxxxxx.TDX</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期，格式YYYYMMDD,下同</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>板块代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨日收盘点</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅%</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量（手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额（万元）, 对于期货指数，该字段存储持仓量</td>
</tr>
<tr>
<td>rise</td>
<td>str</td>
<td>Y</td>
<td>收盘涨速%</td>
</tr>
<tr>
<td>vol_ratio</td>
<td>float</td>
<td>Y</td>
<td>量比</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手%</td>
</tr>
<tr>
<td>swing</td>
<td>float</td>
<td>Y</td>
<td>振幅%</td>
</tr>
<tr>
<td>up_num</td>
<td>int</td>
<td>Y</td>
<td>上涨家数</td>
</tr>
<tr>
<td>down_num</td>
<td>int</td>
<td>Y</td>
<td>下跌家数</td>
</tr>
<tr>
<td>limit_up_num</td>
<td>int</td>
<td>Y</td>
<td>涨停家数</td>
</tr>
<tr>
<td>limit_down_num</td>
<td>int</td>
<td>Y</td>
<td>跌停家数</td>
</tr>
<tr>
<td>lu_days</td>
<td>int</td>
<td>Y</td>
<td>连涨天数</td>
</tr>
<tr>
<td>3day</td>
<td>float</td>
<td>Y</td>
<td>3日涨幅%</td>
</tr>
<tr>
<td>5day</td>
<td>float</td>
<td>Y</td>
<td>5日涨幅%</td>
</tr>
<tr>
<td>10day</td>
<td>float</td>
<td>Y</td>
<td>10日涨幅%</td>
</tr>
<tr>
<td>20day</td>
<td>float</td>
<td>Y</td>
<td>20日涨幅%</td>
</tr>
<tr>
<td>60day</td>
<td>float</td>
<td>Y</td>
<td>60日涨幅%</td>
</tr>
<tr>
<td>mtd</td>
<td>float</td>
<td>Y</td>
<td>月初至今%</td>
</tr>
<tr>
<td>ytd</td>
<td>float</td>
<td>Y</td>
<td>年初至今%</td>
</tr>
<tr>
<td>1year</td>
<td>float</td>
<td>Y</td>
<td>一年涨幅%</td>
</tr>
<tr>
<td>pe</td>
<td>str</td>
<td>Y</td>
<td>市盈率</td>
</tr>
<tr>
<td>pb</td>
<td>str</td>
<td>Y</td>
<td>市净率</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值(亿)</td>
</tr>
<tr>
<td>ab_total_mv</td>
<td>float</td>
<td>Y</td>
<td>AB股总市值（亿）</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股(亿)</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本(亿)</td>
</tr>
<tr>
<td>bm_buy_net</td>
<td>float</td>
<td>Y</td>
<td>主买净额(元)</td>
</tr>
<tr>
<td>bm_buy_ratio</td>
<td>float</td>
<td>Y</td>
<td>主买占比%</td>
</tr>
<tr>
<td>bm_net</td>
<td>float</td>
<td>Y</td>
<td>主力净额</td>
</tr>
<tr>
<td>bm_ratio</td>
<td>float</td>
<td>Y</td>
<td>主力占比%</td>
</tr>
</tbody>
</table>
接口示例

```
#获取通达信2025年5月13日概念板块行情
df = pro.tdx_daily(trade_date='20250513')

```

数据示例

```
    ts_code trade_date    close     open     high  ...  total_share  bm_buy_net  bm_buy_ratio     bm_net  bm_ratio
0    880559.TDX   20250513  4344.82  4243.64  4377.61  ...        63.92    -3711.74         -5.99    3460.16      5.58
1    880728.TDX   20250513  1426.69  1417.49  1429.39  ...      2060.22    -6268.93         -0.29   28491.26      1.32
2    880355.TDX   20250513  1432.23  1403.51  1445.14  ...        70.76     -923.37         -0.17   58055.81     10.40
3    880423.TDX   20250513   919.10   907.35   921.78  ...        56.45    12268.21          8.46     420.44      0.29
4    880875.TDX   20250513  1385.67  1365.73  1387.00  ...      1986.86   207359.44         16.90    3214.69      0.26
..          ...        ...      ...      ...      ...  ...          ...         ...           ...        ...       ...
482  880528.TDX   20250513  1298.93  1334.78  1335.18  ...       579.52  -566197.66        -12.66 -285997.36     -6.40
483  880868.TDX   20250513  1359.55  1412.46  1418.79  ...       108.15   -11975.73         -0.80     -89.57     -0.01
484  880430.TDX   20250513  1865.61  1914.31  1914.31  ...       398.07  -333388.49        -10.96 -200437.09     -6.59
485  880431.TDX   20250513   796.66   825.16   825.16  ...       367.64  -246591.46        -23.97 -131926.99    -12.82
486  880914.TDX   20250513  1009.77  1047.47  1047.55  ...       310.96  -337334.58        -10.57 -423231.69    -13.26

```
