# 通达信板块信息

**文档ID**: 376
**原始链接**: https://tushare.pro/document/2?doc_id=376

---

## 通达信板块信息

接口：tdx_index描述：获取通达信板块基础信息，包括概念板块、行业、风格、地域等限量：单次最大1000条数据，可根据日期参数循环提取权限：用户积累6000积分可调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>板块代码：xxxxxx.TDX</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(格式：YYYYMMDD）</td>
</tr>
<tr>
<td>idx_type</td>
<td>str</td>
<td>N</td>
<td>板块类型：概念板块、行业板块、风格板块、地区板块</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>板块代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>板块名称</td>
</tr>
<tr>
<td>idx_type</td>
<td>str</td>
<td>Y</td>
<td>板块类型</td>
</tr>
<tr>
<td>idx_count</td>
<td>int</td>
<td>Y</td>
<td>成分个数</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本(亿)</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股(亿)</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值(亿)</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值(亿)</td>
</tr>
</tbody></table>
接口示例

```

#获取通达信2025年5月13日的概念板块列表
df = pro.tdx_index(trade_date='20250513', fields='ts_code,name,idx_type,idx_count')


```

数据示例

```
    ts_code           name     idx_type  idx_count
0    880559.TDX   要约收购     风格板块          6
1    880728.TDX   航运概念     概念板块         64
2    880355.TDX   日用化工     行业板块         20
3    880423.TDX   酒店餐饮     行业板块          9
4    880875.TDX   中小银行     风格板块         28
..          ...    ...      ...        ...
477  880528.TDX  军工信息化     概念板块         99
478  880868.TDX   高贝塔值     风格板块        100
479  880430.TDX     航空     行业板块         52
480  880431.TDX     船舶     行业板块         12
481  880914.TDX   军贸概念     概念板块         25

```
