# 通用行情接口

**文档ID**: 109
**原始链接**: https://tushare.pro/document/2?doc_id=109

---

## 通用行情接口

接口名称：pro_bar，本接口是集成开发接口，部分指标是现用现算更新时间：股票和指数通常在15点～17点之间，数字货币实时更新，具体请参考各接口文档明细。描述：目前整合了股票（未复权、前复权、后复权）、指数、数字货币、ETF基金、期货、期权的行情数据，未来还将整合包括外汇在内的所有交易行情数据，同时提供分钟数据。不同数据对应不同的积分要求，具体请参阅每类数据的文档说明。其它：由于本接口是集成接口，在SDK层做了一些逻辑处理，目前暂时没法用http的方式调取通用行情接口。用户可以访问Tushare的Github，查看源代码完成类似功能。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>证券代码，不支持多值输入，多值输入获取结果会有重复记录</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期 (日线格式：YYYYMMDD，提取分钟数据请用2019-09-01 09:00:00这种格式)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期 (日线格式：YYYYMMDD)</td>
</tr>
<tr>
<td>asset</td>
<td>str</td>
<td>Y</td>
<td>资产类别：E股票 I沪深指数 C数字货币 FT期货 FD基金 O期权 CB可转债（v1.2.39），默认E</td>
</tr>
<tr>
<td>adj</td>
<td>str</td>
<td>N</td>
<td>复权类型(只针对股票)：None未复权 qfq前复权 hfq后复权 , 默认None，<strong>目前只支持日线复权</strong>，同时复权机制是根据设定的end_date参数动态复权，采用分红再投模式，具体请参考<a href="https://tushare.pro/document/1?doc_id=122">常见问题列表</a>里的说明。</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>数据频度 ：支持分钟(min)/日(D)/周(W)/月(M)K线，其中1min表示1分钟（类推1/5/15/30/60分钟） ，默认D。对于分钟数据有600积分用户可以试用（请求2次），正式权限可以参考<a href="https://tushare.pro/document/1?doc_id=290"><u>权限列表说明</u></a> ，使用方法请参考<a href="https://tushare.pro/document/1?doc_id=234">股票分钟使用方法</a>。</td>
</tr>
<tr>
<td>ma</td>
<td>list</td>
<td>N</td>
<td>均线，支持任意合理int数值。注：均线是动态计算，要设置一定时间范围才能获得相应的均线，比如5日均线，开始和结束日期参数跨度必须要超过5日。目前只支持单一个股票提取均线，即需要输入ts_code参数。e.g: ma_5表示5日均价，ma_v_5表示5日均量</td>
</tr>
<tr>
<td>factors</td>
<td>list</td>
<td>N</td>
<td>股票因子（asset='E'有效）支持 tor换手率 vr量比</td>
</tr>
<tr>
<td>adjfactor</td>
<td>str</td>
<td>N</td>
<td>复权因子，在复权数据时，如果此参数为True，返回的数据中则带复权因子，默认为False。 该功能从1.2.33版本开始生效</td>
</tr>
</tbody></table>
输出指标

具体输出的数据指标可参考各行情具体指标：

股票Daily：https://tushare.pro/document/2?doc_id=27

基金Daily：https://tushare.pro/document/2?doc_id=127

期货Daily：https://tushare.pro/document/2?doc_id=138

期权Daily：https://tushare.pro/document/2?doc_id=159

指数Daily：https://tushare.pro/document/2?doc_id=95

接口用例

```

#取000001的前复权行情
df = ts.pro_bar(ts_code='000001.SZ', adj='qfq', start_date='20180101', end_date='20181011')

              ts_code trade_date     open     high      low    close  \
trade_date
20181011    000001.SZ   20181011  1085.71  1097.59  1047.90  1065.19
20181010    000001.SZ   20181010  1138.65  1151.61  1121.36  1128.92
20181009    000001.SZ   20181009  1130.00  1155.93  1122.44  1140.81
20181008    000001.SZ   20181008  1155.93  1165.65  1128.92  1128.92
20180928    000001.SZ   20180928  1164.57  1217.51  1164.57  1193.74

```

```

#取上证指数行情数据

df = ts.pro_bar(ts_code='000001.SH', asset='I', start_date='20180101', end_date='20181011')

In [10]: df.head()
Out[10]:
     ts_code trade_date      close       open       high        low  \
0  000001.SH   20181011  2583.4575  2643.0740  2661.2859  2560.3164
1  000001.SH   20181010  2725.8367  2723.7242  2743.5480  2703.0626
2  000001.SH   20181009  2721.0130  2713.7319  2734.3142  2711.1971
3  000001.SH   20181008  2716.5104  2768.2075  2771.9384  2710.1781
4  000001.SH   20180928  2821.3501  2794.2644  2821.7553  2791.8363

   pre_close    change  pct_chg          vol       amount
0  2725.8367 -142.3792     -5.2233  197150702.0  170057762.5
1  2721.0130    4.8237      0.1773  113485736.0  111312455.3
2  2716.5104    4.5026      0.1657  116771899.0  110292457.8
3  2821.3501 -104.8397     -3.7159  149501388.0  141531551.8
4  2791.7748   29.5753      1.0594  134290456.0  125369989.4

```

```

#均线

df = ts.pro_bar(ts_code='000001.SZ', start_date='20180101', end_date='20181011', ma=[5, 20, 50])

```

注：Tushare pro_bar接口的均价和均量数据是动态计算，想要获取某个时间段的均线，必须要设置start_date日期大于最大均线的日期数，然后自行截取想要日期段。例如，想要获取20190801开始的3日均线，必须设置start_date='20190729'，然后剔除20190801之前的日期记录。

```

#换手率tor，量比vr

df = ts.pro_bar(ts_code='000001.SZ', start_date='20180101', end_date='20181011', factors=['tor', 'vr'])

```

说明

对于pro_api参数，如果在一开始就通过 ts.set_token('xxxx') 设置过token的情况，这个参数就不是必需的。

例如：

```

df = ts.pro_bar(ts_code='000001.SH', asset='I', start_date='20180101', end_date='20181011')

```
