# 转融资交易汇总

**文档ID**: 331
**原始链接**: https://tushare.pro/document/2?doc_id=331

---

## 转融资交易汇总

接口：slb_len描述：转融通融资汇总限量：单次最大可以提取5000行数据，可循环获取所有历史积分：2000积分每分钟请求200次，5000积分500次请求

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ob</td>
<td>float</td>
<td>Y</td>
<td>期初余额(亿元)</td>
</tr>
<tr>
<td>auc_amount</td>
<td>float</td>
<td>Y</td>
<td>竞价成交金额(亿元)</td>
</tr>
<tr>
<td>repo_amount</td>
<td>float</td>
<td>Y</td>
<td>再借成交金额(亿元)</td>
</tr>
<tr>
<td>repay_amount</td>
<td>float</td>
<td>Y</td>
<td>偿还金额(亿元)</td>
</tr>
<tr>
<td>cb</td>
<td>float</td>
<td>Y</td>
<td>期末余额(亿元)</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.slb_len(start_date='20240601', end_date='20240620')


```

数据示例

```
     trade_date    ob auc_amount repo_amount repay_amount     cb
0    20240620  1435.50       None        3.10         3.10  1435.50
1    20240619  1435.50       None        2.70         2.70  1435.50
2    20240618  1440.20       None       29.50        34.20  1435.50
3    20240617  1442.20       None        3.00         5.00  1440.20
4    20240614  1442.20       None        None         None  1442.20
5    20240613  1445.20       None        2.90         5.90  1442.20
6    20240612  1445.20       None        3.30         3.30  1445.20
7    20240611  1454.20       None        2.70        11.70  1445.20
8    20240607  1454.20       None        None         None  1454.20
9    20240606  1454.20       None       26.00        26.00  1454.20
10   20240605  1455.60       None        6.00         7.40  1454.20
11   20240604  1406.00      50.00        6.40         6.80  1455.60
12   20240603  1406.00       None        1.00         1.00  1406.00

```
