# 转融券交易明细(停）

**文档ID**: 333
**原始链接**: https://tushare.pro/document/2?doc_id=333

---

## 转融券交易明细

接口：slb_sec_detail描述：转融券交易明细限量：单次最大可以提取5000行数据，可循环获取所有历史积分：2000积分每分钟请求200次，5000积分500次请求

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期（YYYYMMDD）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>tenor</td>
<td>str</td>
<td>Y</td>
<td>期 限(天)</td>
</tr>
<tr>
<td>fee_rate</td>
<td>float</td>
<td>Y</td>
<td>融出费率(%)</td>
</tr>
<tr>
<td>lent_qnt</td>
<td>float</td>
<td>Y</td>
<td>转融券融出数量(万股)</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.slb_sec_detail(trade_date='20240620')


```

数据示例

```
    trade_date    ts_code   name     tenor fee_rate lent_qnt
0     20240620  000001.SZ   平安银行    14     2.20     1.43
1     20240620  000002.SZ    万科Ａ    14     4.60     2.27
2     20240620  000009.SZ   中国宝安    14     7.10     0.66
3     20240620  000016.SZ   深康佳Ａ    14     1.40     9.68
4     20240620  000031.SZ    大悦城    14     3.80     0.22
..         ...        ...    ...   ...      ...      ...
932   20240620  688789.SH   宏华数科    14     1.40     0.84
933   20240620  688798.SH  XD艾为电    14     1.40     1.32
934   20240620  688819.SH   天能股份    14     2.10     0.74
935   20240620  688981.SH   中芯国际    14     3.10     0.10
936   20240620  689009.SH   九号公司    14     1.40     5.72

```
