# 资产负债表

**文档ID**: 36
**原始链接**: https://tushare.pro/document/2?doc_id=36

---

## 资产负债表

接口：balancesheet，可以通过数据工具调试和查看数据。描述：获取上市公司资产负债表积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法提示：当前接口只能按单只股票获取其历史数据，如果需要获取某一季度全部上市公司数据，请使用balancesheet_vip接口（参数一致），需积攒5000积分。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(每个季度最后一天的日期，比如20171231表示年报，20170630半年报，20170930三季报)</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>N</td>
<td>报告类型：见下方详细说明</td>
</tr>
<tr>
<td>comp_type</td>
<td>str</td>
<td>N</td>
<td>公司类型：1一般工商业 2银行 3保险 4证券</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>f_ann_date</td>
<td>str</td>
<td>Y</td>
<td>实际公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报表类型</td>
</tr>
<tr>
<td>comp_type</td>
<td>str</td>
<td>Y</td>
<td>公司类型(1一般工商业2银行3保险4证券)</td>
</tr>
<tr>
<td>end_type</td>
<td>str</td>
<td>Y</td>
<td>报告期类型</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>期末总股本</td>
</tr>
<tr>
<td>cap_rese</td>
<td>float</td>
<td>Y</td>
<td>资本公积金</td>
</tr>
<tr>
<td>undistr_porfit</td>
<td>float</td>
<td>Y</td>
<td>未分配利润</td>
</tr>
<tr>
<td>surplus_rese</td>
<td>float</td>
<td>Y</td>
<td>盈余公积金</td>
</tr>
<tr>
<td>special_rese</td>
<td>float</td>
<td>Y</td>
<td>专项储备</td>
</tr>
<tr>
<td>money_cap</td>
<td>float</td>
<td>Y</td>
<td>货币资金</td>
</tr>
<tr>
<td>trad_asset</td>
<td>float</td>
<td>Y</td>
<td>交易性金融资产</td>
</tr>
<tr>
<td>notes_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收票据</td>
</tr>
<tr>
<td>accounts_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收账款</td>
</tr>
<tr>
<td>oth_receiv</td>
<td>float</td>
<td>Y</td>
<td>其他应收款</td>
</tr>
<tr>
<td>prepayment</td>
<td>float</td>
<td>Y</td>
<td>预付款项</td>
</tr>
<tr>
<td>div_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收股利</td>
</tr>
<tr>
<td>int_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收利息</td>
</tr>
<tr>
<td>inventories</td>
<td>float</td>
<td>Y</td>
<td>存货</td>
</tr>
<tr>
<td>amor_exp</td>
<td>float</td>
<td>Y</td>
<td>待摊费用</td>
</tr>
<tr>
<td>nca_within_1y</td>
<td>float</td>
<td>Y</td>
<td>一年内到期的非流动资产</td>
</tr>
<tr>
<td>sett_rsrv</td>
<td>float</td>
<td>Y</td>
<td>结算备付金</td>
</tr>
<tr>
<td>loanto_oth_bank_fi</td>
<td>float</td>
<td>Y</td>
<td>拆出资金</td>
</tr>
<tr>
<td>premium_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收保费</td>
</tr>
<tr>
<td>reinsur_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收分保账款</td>
</tr>
<tr>
<td>reinsur_res_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收分保合同准备金</td>
</tr>
<tr>
<td>pur_resale_fa</td>
<td>float</td>
<td>Y</td>
<td>买入返售金融资产</td>
</tr>
<tr>
<td>oth_cur_assets</td>
<td>float</td>
<td>Y</td>
<td>其他流动资产</td>
</tr>
<tr>
<td>total_cur_assets</td>
<td>float</td>
<td>Y</td>
<td>流动资产合计</td>
</tr>
<tr>
<td>fa_avail_for_sale</td>
<td>float</td>
<td>Y</td>
<td>可供出售金融资产</td>
</tr>
<tr>
<td>htm_invest</td>
<td>float</td>
<td>Y</td>
<td>持有至到期投资</td>
</tr>
<tr>
<td>lt_eqt_invest</td>
<td>float</td>
<td>Y</td>
<td>长期股权投资</td>
</tr>
<tr>
<td>invest_real_estate</td>
<td>float</td>
<td>Y</td>
<td>投资性房地产</td>
</tr>
<tr>
<td>time_deposits</td>
<td>float</td>
<td>Y</td>
<td>定期存款</td>
</tr>
<tr>
<td>oth_assets</td>
<td>float</td>
<td>Y</td>
<td>其他资产</td>
</tr>
<tr>
<td>lt_rec</td>
<td>float</td>
<td>Y</td>
<td>长期应收款</td>
</tr>
<tr>
<td>fix_assets</td>
<td>float</td>
<td>Y</td>
<td>固定资产</td>
</tr>
<tr>
<td>cip</td>
<td>float</td>
<td>Y</td>
<td>在建工程</td>
</tr>
<tr>
<td>const_materials</td>
<td>float</td>
<td>Y</td>
<td>工程物资</td>
</tr>
<tr>
<td>fixed_assets_disp</td>
<td>float</td>
<td>Y</td>
<td>固定资产清理</td>
</tr>
<tr>
<td>produc_bio_assets</td>
<td>float</td>
<td>Y</td>
<td>生产性生物资产</td>
</tr>
<tr>
<td>oil_and_gas_assets</td>
<td>float</td>
<td>Y</td>
<td>油气资产</td>
</tr>
<tr>
<td>intan_assets</td>
<td>float</td>
<td>Y</td>
<td>无形资产</td>
</tr>
<tr>
<td>r_and_d</td>
<td>float</td>
<td>Y</td>
<td>研发支出</td>
</tr>
<tr>
<td>goodwill</td>
<td>float</td>
<td>Y</td>
<td>商誉</td>
</tr>
<tr>
<td>lt_amor_exp</td>
<td>float</td>
<td>Y</td>
<td>长期待摊费用</td>
</tr>
<tr>
<td>defer_tax_assets</td>
<td>float</td>
<td>Y</td>
<td>递延所得税资产</td>
</tr>
<tr>
<td>decr_in_disbur</td>
<td>float</td>
<td>Y</td>
<td>发放贷款及垫款</td>
</tr>
<tr>
<td>oth_nca</td>
<td>float</td>
<td>Y</td>
<td>其他非流动资产</td>
</tr>
<tr>
<td>total_nca</td>
<td>float</td>
<td>Y</td>
<td>非流动资产合计</td>
</tr>
<tr>
<td>cash_reser_cb</td>
<td>float</td>
<td>Y</td>
<td>现金及存放中央银行款项</td>
</tr>
<tr>
<td>depos_in_oth_bfi</td>
<td>float</td>
<td>Y</td>
<td>存放同业和其它金融机构款项</td>
</tr>
<tr>
<td>prec_metals</td>
<td>float</td>
<td>Y</td>
<td>贵金属</td>
</tr>
<tr>
<td>deriv_assets</td>
<td>float</td>
<td>Y</td>
<td>衍生金融资产</td>
</tr>
<tr>
<td>rr_reins_une_prem</td>
<td>float</td>
<td>Y</td>
<td>应收分保未到期责任准备金</td>
</tr>
<tr>
<td>rr_reins_outstd_cla</td>
<td>float</td>
<td>Y</td>
<td>应收分保未决赔款准备金</td>
</tr>
<tr>
<td>rr_reins_lins_liab</td>
<td>float</td>
<td>Y</td>
<td>应收分保寿险责任准备金</td>
</tr>
<tr>
<td>rr_reins_lthins_liab</td>
<td>float</td>
<td>Y</td>
<td>应收分保长期健康险责任准备金</td>
</tr>
<tr>
<td>refund_depos</td>
<td>float</td>
<td>Y</td>
<td>存出保证金</td>
</tr>
<tr>
<td>ph_pledge_loans</td>
<td>float</td>
<td>Y</td>
<td>保户质押贷款</td>
</tr>
<tr>
<td>refund_cap_depos</td>
<td>float</td>
<td>Y</td>
<td>存出资本保证金</td>
</tr>
<tr>
<td>indep_acct_assets</td>
<td>float</td>
<td>Y</td>
<td>独立账户资产</td>
</tr>
<tr>
<td>client_depos</td>
<td>float</td>
<td>Y</td>
<td>其中：客户资金存款</td>
</tr>
<tr>
<td>client_prov</td>
<td>float</td>
<td>Y</td>
<td>其中：客户备付金</td>
</tr>
<tr>
<td>transac_seat_fee</td>
<td>float</td>
<td>Y</td>
<td>其中:交易席位费</td>
</tr>
<tr>
<td>invest_as_receiv</td>
<td>float</td>
<td>Y</td>
<td>应收款项类投资</td>
</tr>
<tr>
<td>total_assets</td>
<td>float</td>
<td>Y</td>
<td>资产总计</td>
</tr>
<tr>
<td>lt_borr</td>
<td>float</td>
<td>Y</td>
<td>长期借款</td>
</tr>
<tr>
<td>st_borr</td>
<td>float</td>
<td>Y</td>
<td>短期借款</td>
</tr>
<tr>
<td>cb_borr</td>
<td>float</td>
<td>Y</td>
<td>向中央银行借款</td>
</tr>
<tr>
<td>depos_ib_deposits</td>
<td>float</td>
<td>Y</td>
<td>吸收存款及同业存放</td>
</tr>
<tr>
<td>loan_oth_bank</td>
<td>float</td>
<td>Y</td>
<td>拆入资金</td>
</tr>
<tr>
<td>trading_fl</td>
<td>float</td>
<td>Y</td>
<td>交易性金融负债</td>
</tr>
<tr>
<td>notes_payable</td>
<td>float</td>
<td>Y</td>
<td>应付票据</td>
</tr>
<tr>
<td>acct_payable</td>
<td>float</td>
<td>Y</td>
<td>应付账款</td>
</tr>
<tr>
<td>adv_receipts</td>
<td>float</td>
<td>Y</td>
<td>预收款项</td>
</tr>
<tr>
<td>sold_for_repur_fa</td>
<td>float</td>
<td>Y</td>
<td>卖出回购金融资产款</td>
</tr>
<tr>
<td>comm_payable</td>
<td>float</td>
<td>Y</td>
<td>应付手续费及佣金</td>
</tr>
<tr>
<td>payroll_payable</td>
<td>float</td>
<td>Y</td>
<td>应付职工薪酬</td>
</tr>
<tr>
<td>taxes_payable</td>
<td>float</td>
<td>Y</td>
<td>应交税费</td>
</tr>
<tr>
<td>int_payable</td>
<td>float</td>
<td>Y</td>
<td>应付利息</td>
</tr>
<tr>
<td>div_payable</td>
<td>float</td>
<td>Y</td>
<td>应付股利</td>
</tr>
<tr>
<td>oth_payable</td>
<td>float</td>
<td>Y</td>
<td>其他应付款</td>
</tr>
<tr>
<td>acc_exp</td>
<td>float</td>
<td>Y</td>
<td>预提费用</td>
</tr>
<tr>
<td>deferred_inc</td>
<td>float</td>
<td>Y</td>
<td>递延收益</td>
</tr>
<tr>
<td>st_bonds_payable</td>
<td>float</td>
<td>Y</td>
<td>应付短期债券</td>
</tr>
<tr>
<td>payable_to_reinsurer</td>
<td>float</td>
<td>Y</td>
<td>应付分保账款</td>
</tr>
<tr>
<td>rsrv_insur_cont</td>
<td>float</td>
<td>Y</td>
<td>保险合同准备金</td>
</tr>
<tr>
<td>acting_trading_sec</td>
<td>float</td>
<td>Y</td>
<td>代理买卖证券款</td>
</tr>
<tr>
<td>acting_uw_sec</td>
<td>float</td>
<td>Y</td>
<td>代理承销证券款</td>
</tr>
<tr>
<td>non_cur_liab_due_1y</td>
<td>float</td>
<td>Y</td>
<td>一年内到期的非流动负债</td>
</tr>
<tr>
<td>oth_cur_liab</td>
<td>float</td>
<td>Y</td>
<td>其他流动负债</td>
</tr>
<tr>
<td>total_cur_liab</td>
<td>float</td>
<td>Y</td>
<td>流动负债合计</td>
</tr>
<tr>
<td>bond_payable</td>
<td>float</td>
<td>Y</td>
<td>应付债券</td>
</tr>
<tr>
<td>lt_payable</td>
<td>float</td>
<td>Y</td>
<td>长期应付款</td>
</tr>
<tr>
<td>specific_payables</td>
<td>float</td>
<td>Y</td>
<td>专项应付款</td>
</tr>
<tr>
<td>estimated_liab</td>
<td>float</td>
<td>Y</td>
<td>预计负债</td>
</tr>
<tr>
<td>defer_tax_liab</td>
<td>float</td>
<td>Y</td>
<td>递延所得税负债</td>
</tr>
<tr>
<td>defer_inc_non_cur_liab</td>
<td>float</td>
<td>Y</td>
<td>递延收益-非流动负债</td>
</tr>
<tr>
<td>oth_ncl</td>
<td>float</td>
<td>Y</td>
<td>其他非流动负债</td>
</tr>
<tr>
<td>total_ncl</td>
<td>float</td>
<td>Y</td>
<td>非流动负债合计</td>
</tr>
<tr>
<td>depos_oth_bfi</td>
<td>float</td>
<td>Y</td>
<td>同业和其它金融机构存放款项</td>
</tr>
<tr>
<td>deriv_liab</td>
<td>float</td>
<td>Y</td>
<td>衍生金融负债</td>
</tr>
<tr>
<td>depos</td>
<td>float</td>
<td>Y</td>
<td>吸收存款</td>
</tr>
<tr>
<td>agency_bus_liab</td>
<td>float</td>
<td>Y</td>
<td>代理业务负债</td>
</tr>
<tr>
<td>oth_liab</td>
<td>float</td>
<td>Y</td>
<td>其他负债</td>
</tr>
<tr>
<td>prem_receiv_adva</td>
<td>float</td>
<td>Y</td>
<td>预收保费</td>
</tr>
<tr>
<td>depos_received</td>
<td>float</td>
<td>Y</td>
<td>存入保证金</td>
</tr>
<tr>
<td>ph_invest</td>
<td>float</td>
<td>Y</td>
<td>保户储金及投资款</td>
</tr>
<tr>
<td>reser_une_prem</td>
<td>float</td>
<td>Y</td>
<td>未到期责任准备金</td>
</tr>
<tr>
<td>reser_outstd_claims</td>
<td>float</td>
<td>Y</td>
<td>未决赔款准备金</td>
</tr>
<tr>
<td>reser_lins_liab</td>
<td>float</td>
<td>Y</td>
<td>寿险责任准备金</td>
</tr>
<tr>
<td>reser_lthins_liab</td>
<td>float</td>
<td>Y</td>
<td>长期健康险责任准备金</td>
</tr>
<tr>
<td>indept_acc_liab</td>
<td>float</td>
<td>Y</td>
<td>独立账户负债</td>
</tr>
<tr>
<td>pledge_borr</td>
<td>float</td>
<td>Y</td>
<td>其中:质押借款</td>
</tr>
<tr>
<td>indem_payable</td>
<td>float</td>
<td>Y</td>
<td>应付赔付款</td>
</tr>
<tr>
<td>policy_div_payable</td>
<td>float</td>
<td>Y</td>
<td>应付保单红利</td>
</tr>
<tr>
<td>total_liab</td>
<td>float</td>
<td>Y</td>
<td>负债合计</td>
</tr>
<tr>
<td>treasury_share</td>
<td>float</td>
<td>Y</td>
<td>减:库存股</td>
</tr>
<tr>
<td>ordin_risk_reser</td>
<td>float</td>
<td>Y</td>
<td>一般风险准备</td>
</tr>
<tr>
<td>forex_differ</td>
<td>float</td>
<td>Y</td>
<td>外币报表折算差额</td>
</tr>
<tr>
<td>invest_loss_unconf</td>
<td>float</td>
<td>Y</td>
<td>未确认的投资损失</td>
</tr>
<tr>
<td>minority_int</td>
<td>float</td>
<td>Y</td>
<td>少数股东权益</td>
</tr>
<tr>
<td>total_hldr_eqy_exc_min_int</td>
<td>float</td>
<td>Y</td>
<td>股东权益合计(不含少数股东权益)</td>
</tr>
<tr>
<td>total_hldr_eqy_inc_min_int</td>
<td>float</td>
<td>Y</td>
<td>股东权益合计(含少数股东权益)</td>
</tr>
<tr>
<td>total_liab_hldr_eqy</td>
<td>float</td>
<td>Y</td>
<td>负债及股东权益总计</td>
</tr>
<tr>
<td>lt_payroll_payable</td>
<td>float</td>
<td>Y</td>
<td>长期应付职工薪酬</td>
</tr>
<tr>
<td>oth_comp_income</td>
<td>float</td>
<td>Y</td>
<td>其他综合收益</td>
</tr>
<tr>
<td>oth_eqt_tools</td>
<td>float</td>
<td>Y</td>
<td>其他权益工具</td>
</tr>
<tr>
<td>oth_eqt_tools_p_shr</td>
<td>float</td>
<td>Y</td>
<td>其他权益工具(优先股)</td>
</tr>
<tr>
<td>lending_funds</td>
<td>float</td>
<td>Y</td>
<td>融出资金</td>
</tr>
<tr>
<td>acc_receivable</td>
<td>float</td>
<td>Y</td>
<td>应收款项</td>
</tr>
<tr>
<td>st_fin_payable</td>
<td>float</td>
<td>Y</td>
<td>应付短期融资款</td>
</tr>
<tr>
<td>payables</td>
<td>float</td>
<td>Y</td>
<td>应付款项</td>
</tr>
<tr>
<td>hfs_assets</td>
<td>float</td>
<td>Y</td>
<td>持有待售的资产</td>
</tr>
<tr>
<td>hfs_sales</td>
<td>float</td>
<td>Y</td>
<td>持有待售的负债</td>
</tr>
<tr>
<td>cost_fin_assets</td>
<td>float</td>
<td>Y</td>
<td>以摊余成本计量的金融资产</td>
</tr>
<tr>
<td>fair_value_fin_assets</td>
<td>float</td>
<td>Y</td>
<td>以公允价值计量且其变动计入其他综合收益的金融资产</td>
</tr>
<tr>
<td>cip_total</td>
<td>float</td>
<td>Y</td>
<td>在建工程(合计)(元)</td>
</tr>
<tr>
<td>oth_pay_total</td>
<td>float</td>
<td>Y</td>
<td>其他应付款(合计)(元)</td>
</tr>
<tr>
<td>long_pay_total</td>
<td>float</td>
<td>Y</td>
<td>长期应付款(合计)(元)</td>
</tr>
<tr>
<td>debt_invest</td>
<td>float</td>
<td>Y</td>
<td>债权投资(元)</td>
</tr>
<tr>
<td>oth_debt_invest</td>
<td>float</td>
<td>Y</td>
<td>其他债权投资(元)</td>
</tr>
<tr>
<td>oth_eq_invest</td>
<td>float</td>
<td>N</td>
<td>其他权益工具投资(元)</td>
</tr>
<tr>
<td>oth_illiq_fin_assets</td>
<td>float</td>
<td>N</td>
<td>其他非流动金融资产(元)</td>
</tr>
<tr>
<td>oth_eq_ppbond</td>
<td>float</td>
<td>N</td>
<td>其他权益工具:永续债(元)</td>
</tr>
<tr>
<td>receiv_financing</td>
<td>float</td>
<td>N</td>
<td>应收款项融资</td>
</tr>
<tr>
<td>use_right_assets</td>
<td>float</td>
<td>N</td>
<td>使用权资产</td>
</tr>
<tr>
<td>lease_liab</td>
<td>float</td>
<td>N</td>
<td>租赁负债</td>
</tr>
<tr>
<td>contract_assets</td>
<td>float</td>
<td>Y</td>
<td>合同资产</td>
</tr>
<tr>
<td>contract_liab</td>
<td>float</td>
<td>Y</td>
<td>合同负债</td>
</tr>
<tr>
<td>accounts_receiv_bill</td>
<td>float</td>
<td>Y</td>
<td>应收票据及应收账款</td>
</tr>
<tr>
<td>accounts_pay</td>
<td>float</td>
<td>Y</td>
<td>应付票据及应付账款</td>
</tr>
<tr>
<td>oth_rcv_total</td>
<td>float</td>
<td>Y</td>
<td>其他应收款(合计)（元）</td>
</tr>
<tr>
<td>fix_assets_total</td>
<td>float</td>
<td>Y</td>
<td>固定资产(合计)(元)</td>
</tr>
<tr>
<td>update_flag</td>
<td>str</td>
<td>Y</td>
<td>更新标识</td>
</tr>
</tbody></table>
接口使用说明

```

pro = ts.pro_api()

df = pro.balancesheet(ts_code='600000.SH', start_date='20180101', end_date='20180730', fields='ts_code,ann_date,f_ann_date,end_date,report_type,comp_type,cap_rese')

```

获取某一季度全部股票数据

```
df2 = pro.balancesheet_vip(period='20181231',fields='ts_code,ann_date,f_ann_date,end_date,report_type,comp_type,cap_rese')

```

数据样例

```
         ts_code  ann_date f_ann_date  end_date report_type comp_type  \
0  600000.SH  20180830   20180830  20180630           1         2   
1  600000.SH  20180428   20180428  20180331           1         2   

             cap_rese  
0  8.176000e+10  
1  8.176000e+10 

```

主要报表类型说明

<table>
<thead>
<tr>
<th>代码</th>
<th>类型</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1</td>
<td>合并报表</td>
<td>上市公司最新报表（默认）</td>
</tr>
<tr>
<td>2</td>
<td>单季合并</td>
<td>单一季度的合并报表</td>
</tr>
<tr>
<td>3</td>
<td>调整单季合并表</td>
<td>调整后的单季合并报表（如果有）</td>
</tr>
<tr>
<td>4</td>
<td>调整合并报表</td>
<td>本年度公布上年同期的财务报表数据，报告期为上年度</td>
</tr>
<tr>
<td>5</td>
<td>调整前合并报表</td>
<td>数据发生变更，将原数据进行保留，即调整前的原数据</td>
</tr>
<tr>
<td>6</td>
<td>母公司报表</td>
<td>该公司母公司的财务报表数据</td>
</tr>
<tr>
<td>7</td>
<td>母公司单季表</td>
<td>母公司的单季度表</td>
</tr>
<tr>
<td>8</td>
<td>母公司调整单季表</td>
<td>母公司调整后的单季表</td>
</tr>
<tr>
<td>9</td>
<td>母公司调整表</td>
<td>该公司母公司的本年度公布上年同期的财务报表数据</td>
</tr>
<tr>
<td>10</td>
<td>母公司调整前报表</td>
<td>母公司调整之前的原始财务报表数据</td>
</tr>
<tr>
<td>11</td>
<td>母公司调整前合并报表</td>
<td>母公司调整之前合并报表原数据</td>
</tr>
<tr>
<td>12</td>
<td>母公司调整前报表</td>
<td>母公司报表发生变更前保留的原数据</td>
</tr>
</tbody></table>