# 货币供应量（月）

**文档ID**: 242
**原始链接**: https://tushare.pro/document/2?doc_id=242

---

## 货币供应量

接口：cn_m描述：获取货币供应量之月度数据限量：单次最大5000，一次可以提取全部数据权限：用户积累600积分可以使用，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>m</td>
<td>str</td>
<td>N</td>
<td>月度（202001表示，2020年1月）</td>
</tr>
<tr>
<td>start_m</td>
<td>str</td>
<td>N</td>
<td>开始月度</td>
</tr>
<tr>
<td>end_m</td>
<td>str</td>
<td>N</td>
<td>结束月度</td>
</tr>
<tr>
<td>fields</td>
<td>str</td>
<td>N</td>
<td>指定输出字段（e.g. fields='month,m0,m1,m2'）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>month</td>
<td>str</td>
<td>Y</td>
<td>月份YYYYMM</td>
</tr>
<tr>
<td>m0</td>
<td>float</td>
<td>Y</td>
<td>M0（亿元）</td>
</tr>
<tr>
<td>m0_yoy</td>
<td>float</td>
<td>Y</td>
<td>M0同比（%）</td>
</tr>
<tr>
<td>m0_mom</td>
<td>float</td>
<td>Y</td>
<td>M0环比（%）</td>
</tr>
<tr>
<td>m1</td>
<td>float</td>
<td>Y</td>
<td>M1（亿元）</td>
</tr>
<tr>
<td>m1_yoy</td>
<td>float</td>
<td>Y</td>
<td>M1同比（%）</td>
</tr>
<tr>
<td>m1_mom</td>
<td>float</td>
<td>Y</td>
<td>M1环比（%）</td>
</tr>
<tr>
<td>m2</td>
<td>float</td>
<td>Y</td>
<td>M2（亿元）</td>
</tr>
<tr>
<td>m2_yoy</td>
<td>float</td>
<td>Y</td>
<td>M2同比（%）</td>
</tr>
<tr>
<td>m2_mom</td>
<td>float</td>
<td>Y</td>
<td>M2环比（%）</td>
</tr>
</tbody></table>
接口调用

```
pro = ts.pro_api()
df = pro.cn_m(start_m='201901', end_m='202003')
#获取指定字段
df = pro.cn_m(start_m='201901', end_m='202003', fields='month,m0,m1,m2')

```

数据样例

```
    month        m0 m0_yoy m0_mom         m1 m1_yoy m1_mom          m2 m2_yoy m2_mom
0   202003  83000.00  10.80  -5.90  575100.00   5.00   4.05  2080900.00  10.10   2.47
1   202002  88200.00  10.90  -5.36  552700.00   4.80   1.32  2030800.00   8.80   0.38
2   202001  93200.00   6.60  20.73  545500.00   0.00  -5.30  2023100.00   8.40   1.84
3   201912  77200.00   5.40   4.36  576000.00   4.40   2.40  1986500.00   8.70   1.28
4   201911  73973.82   4.80   0.79  562486.52   3.50   0.78  1961429.56   8.20   0.81
5   201910  73395.40   4.70  -0.99  558143.92   3.30   0.18  1945600.55   8.40  -0.34
6   201909  74129.75   4.00   1.34  557137.95   3.40   0.06  1952250.49   8.40   0.87
7   201908  73152.62   4.80   0.64  556798.09   3.40   0.68  1935492.43   8.20   0.84
8   201907  72689.25   4.50   0.15  553043.11   3.10  -2.58  1919410.82   8.10  -0.10
9   201906  72580.96   4.30  -0.30  567696.18   4.40   4.29  1921360.19   8.50   1.60
10  201905  72798.46   4.30  -1.58  544355.64   3.40   0.69  1891153.70   8.50   0.34
11  201904  73965.76   3.50  -1.30  540614.60   2.90  -1.27  1884670.33   8.50  -0.25
12  201903  74941.58   3.10  -5.72  547575.54   4.60   3.87  1889412.14   8.60   1.18
13  201902  79484.72  -2.40  -9.13  527190.48   1.60  -3.38  1867427.45   8.00   0.08
14  201901  87470.62  17.20  19.48  545638.46   0.40  -1.10  1865935.33   8.40   2.15

```
