# 财报披露日期表

**文档ID**: 162
**原始链接**: https://tushare.pro/document/2?doc_id=162

---

## 财报披露计划

接口：disclosure_date描述：获取财报披露计划日期限量：单次最大3000，总量不限制积分：用户需要至少500积分才可以调取，积分越多权限越大，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>财报周期（每个季度最后一天的日期，比如20181231表示2018年年报，20180630表示中报)</td>
</tr>
<tr>
<td>pre_date</td>
<td>str</td>
<td>N</td>
<td>计划披露日期</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>最新披露公告日</td>
</tr>
<tr>
<td>actual_date</td>
<td>str</td>
<td>N</td>
<td>实际披露日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>最新披露公告日</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>pre_date</td>
<td>str</td>
<td>Y</td>
<td>预计披露日期</td>
</tr>
<tr>
<td>actual_date</td>
<td>str</td>
<td>Y</td>
<td>实际披露日期</td>
</tr>
<tr>
<td>modify_date</td>
<td>str</td>
<td>N</td>
<td>披露日期修正记录</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

df = pro.disclosure_date(end_date='20181231')

```

数据示例

```
        ts_code  ann_date  end_date  pre_date actual_date modify_date
0     300619.SZ  20181228  20181231  20190122    20190122        None
1     300125.SZ  20181228  20181231  20190129    20190129        None
2     601619.SH  20181227  20181231  20190129    20190129        None
3     000055.SZ  20181228  20181231  20190130    20190130        None
4     002910.SZ  20181228  20181231  20190131        None        None
5     002188.SZ  20181228  20181231  20190131        None        None
6     600738.SH  20190124  20181231  20190131        None        None
7     002107.SZ  20181228  20181231  20190201        None        None
8     300748.SZ  20181228  20181231  20190201        None        None
9     002675.SZ  20181228  20181231  20190201        None        None
10    002167.SZ  20181228  20181231  20190201        None        None
11    002211.SZ  20190125  20181231  20190201        None        None
12    002240.SZ  20181228  20181231  20190201        None        None
13    002245.SZ  20181228  20181231  20190201        None        None
14    002552.SZ  20181228  20181231  20190201        None        None
15    002825.SZ  20181228  20181231  20190201        None        None

```
