# 财务指标数据

**文档ID**: 79
**原始链接**: https://tushare.pro/document/2?doc_id=79

---

## 财务指标数据

接口：fina_indicator，可以通过数据工具调试和查看数据。描述：获取上市公司财务指标数据，为避免服务器压力，现阶段每次请求最多返回100条记录，可通过设置日期多次请求获取更多数据。权限：用户需要至少2000积分才可以调取，具体请参阅积分获取办法提示：当前接口只能按单只股票获取其历史数据，如果需要获取某一季度全部上市公司数据，请使用fina_indicator_vip接口（参数一致），需积攒5000积分。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码,e.g. 600001.SH/000001.SZ</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告期结束日期</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(每个季度最后一天的日期,比如20171231表示年报)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>eps</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益</td>
</tr>
<tr>
<td>dt_eps</td>
<td>float</td>
<td>Y</td>
<td>稀释每股收益</td>
</tr>
<tr>
<td>total_revenue_ps</td>
<td>float</td>
<td>Y</td>
<td>每股营业总收入</td>
</tr>
<tr>
<td>revenue_ps</td>
<td>float</td>
<td>Y</td>
<td>每股营业收入</td>
</tr>
<tr>
<td>capital_rese_ps</td>
<td>float</td>
<td>Y</td>
<td>每股资本公积</td>
</tr>
<tr>
<td>surplus_rese_ps</td>
<td>float</td>
<td>Y</td>
<td>每股盈余公积</td>
</tr>
<tr>
<td>undist_profit_ps</td>
<td>float</td>
<td>Y</td>
<td>每股未分配利润</td>
</tr>
<tr>
<td>extra_item</td>
<td>float</td>
<td>Y</td>
<td>非经常性损益</td>
</tr>
<tr>
<td>profit_dedt</td>
<td>float</td>
<td>Y</td>
<td>扣除非经常性损益后的净利润（扣非净利润）</td>
</tr>
<tr>
<td>gross_margin</td>
<td>float</td>
<td>Y</td>
<td>毛利</td>
</tr>
<tr>
<td>current_ratio</td>
<td>float</td>
<td>Y</td>
<td>流动比率</td>
</tr>
<tr>
<td>quick_ratio</td>
<td>float</td>
<td>Y</td>
<td>速动比率</td>
</tr>
<tr>
<td>cash_ratio</td>
<td>float</td>
<td>Y</td>
<td>保守速动比率</td>
</tr>
<tr>
<td>invturn_days</td>
<td>float</td>
<td>N</td>
<td>存货周转天数</td>
</tr>
<tr>
<td>arturn_days</td>
<td>float</td>
<td>N</td>
<td>应收账款周转天数</td>
</tr>
<tr>
<td>inv_turn</td>
<td>float</td>
<td>N</td>
<td>存货周转率</td>
</tr>
<tr>
<td>ar_turn</td>
<td>float</td>
<td>Y</td>
<td>应收账款周转率</td>
</tr>
<tr>
<td>ca_turn</td>
<td>float</td>
<td>Y</td>
<td>流动资产周转率</td>
</tr>
<tr>
<td>fa_turn</td>
<td>float</td>
<td>Y</td>
<td>固定资产周转率</td>
</tr>
<tr>
<td>assets_turn</td>
<td>float</td>
<td>Y</td>
<td>总资产周转率</td>
</tr>
<tr>
<td>op_income</td>
<td>float</td>
<td>Y</td>
<td>经营活动净收益</td>
</tr>
<tr>
<td>valuechange_income</td>
<td>float</td>
<td>N</td>
<td>价值变动净收益</td>
</tr>
<tr>
<td>interst_income</td>
<td>float</td>
<td>N</td>
<td>利息费用</td>
</tr>
<tr>
<td>daa</td>
<td>float</td>
<td>N</td>
<td>折旧与摊销</td>
</tr>
<tr>
<td>ebit</td>
<td>float</td>
<td>Y</td>
<td>息税前利润</td>
</tr>
<tr>
<td>ebitda</td>
<td>float</td>
<td>Y</td>
<td>息税折旧摊销前利润</td>
</tr>
<tr>
<td>fcff</td>
<td>float</td>
<td>Y</td>
<td>企业自由现金流量</td>
</tr>
<tr>
<td>fcfe</td>
<td>float</td>
<td>Y</td>
<td>股权自由现金流量</td>
</tr>
<tr>
<td>current_exint</td>
<td>float</td>
<td>Y</td>
<td>无息流动负债</td>
</tr>
<tr>
<td>noncurrent_exint</td>
<td>float</td>
<td>Y</td>
<td>无息非流动负债</td>
</tr>
<tr>
<td>interestdebt</td>
<td>float</td>
<td>Y</td>
<td>带息债务</td>
</tr>
<tr>
<td>netdebt</td>
<td>float</td>
<td>Y</td>
<td>净债务</td>
</tr>
<tr>
<td>tangible_asset</td>
<td>float</td>
<td>Y</td>
<td>有形资产</td>
</tr>
<tr>
<td>working_capital</td>
<td>float</td>
<td>Y</td>
<td>营运资金</td>
</tr>
<tr>
<td>networking_capital</td>
<td>float</td>
<td>Y</td>
<td>营运流动资本</td>
</tr>
<tr>
<td>invest_capital</td>
<td>float</td>
<td>Y</td>
<td>全部投入资本</td>
</tr>
<tr>
<td>retained_earnings</td>
<td>float</td>
<td>Y</td>
<td>留存收益</td>
</tr>
<tr>
<td>diluted2_eps</td>
<td>float</td>
<td>Y</td>
<td>期末摊薄每股收益</td>
</tr>
<tr>
<td>bps</td>
<td>float</td>
<td>Y</td>
<td>每股净资产</td>
</tr>
<tr>
<td>ocfps</td>
<td>float</td>
<td>Y</td>
<td>每股经营活动产生的现金流量净额</td>
</tr>
<tr>
<td>retainedps</td>
<td>float</td>
<td>Y</td>
<td>每股留存收益</td>
</tr>
<tr>
<td>cfps</td>
<td>float</td>
<td>Y</td>
<td>每股现金流量净额</td>
</tr>
<tr>
<td>ebit_ps</td>
<td>float</td>
<td>Y</td>
<td>每股息税前利润</td>
</tr>
<tr>
<td>fcff_ps</td>
<td>float</td>
<td>Y</td>
<td>每股企业自由现金流量</td>
</tr>
<tr>
<td>fcfe_ps</td>
<td>float</td>
<td>Y</td>
<td>每股股东自由现金流量</td>
</tr>
<tr>
<td>netprofit_margin</td>
<td>float</td>
<td>Y</td>
<td>销售净利率</td>
</tr>
<tr>
<td>grossprofit_margin</td>
<td>float</td>
<td>Y</td>
<td>销售毛利率</td>
</tr>
<tr>
<td>cogs_of_sales</td>
<td>float</td>
<td>Y</td>
<td>销售成本率</td>
</tr>
<tr>
<td>expense_of_sales</td>
<td>float</td>
<td>Y</td>
<td>销售期间费用率</td>
</tr>
<tr>
<td>profit_to_gr</td>
<td>float</td>
<td>Y</td>
<td>净利润/营业总收入</td>
</tr>
<tr>
<td>saleexp_to_gr</td>
<td>float</td>
<td>Y</td>
<td>销售费用/营业总收入</td>
</tr>
<tr>
<td>adminexp_of_gr</td>
<td>float</td>
<td>Y</td>
<td>管理费用/营业总收入</td>
</tr>
<tr>
<td>finaexp_of_gr</td>
<td>float</td>
<td>Y</td>
<td>财务费用/营业总收入</td>
</tr>
<tr>
<td>impai_ttm</td>
<td>float</td>
<td>Y</td>
<td>资产减值损失/营业总收入</td>
</tr>
<tr>
<td>gc_of_gr</td>
<td>float</td>
<td>Y</td>
<td>营业总成本/营业总收入</td>
</tr>
<tr>
<td>op_of_gr</td>
<td>float</td>
<td>Y</td>
<td>营业利润/营业总收入</td>
</tr>
<tr>
<td>ebit_of_gr</td>
<td>float</td>
<td>Y</td>
<td>息税前利润/营业总收入</td>
</tr>
<tr>
<td>roe</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率</td>
</tr>
<tr>
<td>roe_waa</td>
<td>float</td>
<td>Y</td>
<td>加权平均净资产收益率</td>
</tr>
<tr>
<td>roe_dt</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率(扣除非经常损益)</td>
</tr>
<tr>
<td>roa</td>
<td>float</td>
<td>Y</td>
<td>总资产报酬率</td>
</tr>
<tr>
<td>npta</td>
<td>float</td>
<td>Y</td>
<td>总资产净利润</td>
</tr>
<tr>
<td>roic</td>
<td>float</td>
<td>Y</td>
<td>投入资本回报率</td>
</tr>
<tr>
<td>roe_yearly</td>
<td>float</td>
<td>Y</td>
<td>年化净资产收益率</td>
</tr>
<tr>
<td>roa2_yearly</td>
<td>float</td>
<td>Y</td>
<td>年化总资产报酬率</td>
</tr>
<tr>
<td>roe_avg</td>
<td>float</td>
<td>N</td>
<td>平均净资产收益率(增发条件)</td>
</tr>
<tr>
<td>opincome_of_ebt</td>
<td>float</td>
<td>N</td>
<td>经营活动净收益/利润总额</td>
</tr>
<tr>
<td>investincome_of_ebt</td>
<td>float</td>
<td>N</td>
<td>价值变动净收益/利润总额</td>
</tr>
<tr>
<td>n_op_profit_of_ebt</td>
<td>float</td>
<td>N</td>
<td>营业外收支净额/利润总额</td>
</tr>
<tr>
<td>tax_to_ebt</td>
<td>float</td>
<td>N</td>
<td>所得税/利润总额</td>
</tr>
<tr>
<td>dtprofit_to_profit</td>
<td>float</td>
<td>N</td>
<td>扣除非经常损益后的净利润/净利润</td>
</tr>
<tr>
<td>salescash_to_or</td>
<td>float</td>
<td>N</td>
<td>销售商品提供劳务收到的现金/营业收入</td>
</tr>
<tr>
<td>ocf_to_or</td>
<td>float</td>
<td>N</td>
<td>经营活动产生的现金流量净额/营业收入</td>
</tr>
<tr>
<td>ocf_to_opincome</td>
<td>float</td>
<td>N</td>
<td>经营活动产生的现金流量净额/经营活动净收益</td>
</tr>
<tr>
<td>capitalized_to_da</td>
<td>float</td>
<td>N</td>
<td>资本支出/折旧和摊销</td>
</tr>
<tr>
<td>debt_to_assets</td>
<td>float</td>
<td>Y</td>
<td>资产负债率</td>
</tr>
<tr>
<td>assets_to_eqt</td>
<td>float</td>
<td>Y</td>
<td>权益乘数</td>
</tr>
<tr>
<td>dp_assets_to_eqt</td>
<td>float</td>
<td>Y</td>
<td>权益乘数(杜邦分析)</td>
</tr>
<tr>
<td>ca_to_assets</td>
<td>float</td>
<td>Y</td>
<td>流动资产/总资产</td>
</tr>
<tr>
<td>nca_to_assets</td>
<td>float</td>
<td>Y</td>
<td>非流动资产/总资产</td>
</tr>
<tr>
<td>tbassets_to_totalassets</td>
<td>float</td>
<td>Y</td>
<td>有形资产/总资产</td>
</tr>
<tr>
<td>int_to_talcap</td>
<td>float</td>
<td>Y</td>
<td>带息债务/全部投入资本</td>
</tr>
<tr>
<td>eqt_to_talcapital</td>
<td>float</td>
<td>Y</td>
<td>归属于母公司的股东权益/全部投入资本</td>
</tr>
<tr>
<td>currentdebt_to_debt</td>
<td>float</td>
<td>Y</td>
<td>流动负债/负债合计</td>
</tr>
<tr>
<td>longdeb_to_debt</td>
<td>float</td>
<td>Y</td>
<td>非流动负债/负债合计</td>
</tr>
<tr>
<td>ocf_to_shortdebt</td>
<td>float</td>
<td>Y</td>
<td>经营活动产生的现金流量净额/流动负债</td>
</tr>
<tr>
<td>debt_to_eqt</td>
<td>float</td>
<td>Y</td>
<td>产权比率</td>
</tr>
<tr>
<td>eqt_to_debt</td>
<td>float</td>
<td>Y</td>
<td>归属于母公司的股东权益/负债合计</td>
</tr>
<tr>
<td>eqt_to_interestdebt</td>
<td>float</td>
<td>Y</td>
<td>归属于母公司的股东权益/带息债务</td>
</tr>
<tr>
<td>tangibleasset_to_debt</td>
<td>float</td>
<td>Y</td>
<td>有形资产/负债合计</td>
</tr>
<tr>
<td>tangasset_to_intdebt</td>
<td>float</td>
<td>Y</td>
<td>有形资产/带息债务</td>
</tr>
<tr>
<td>tangibleasset_to_netdebt</td>
<td>float</td>
<td>Y</td>
<td>有形资产/净债务</td>
</tr>
<tr>
<td>ocf_to_debt</td>
<td>float</td>
<td>Y</td>
<td>经营活动产生的现金流量净额/负债合计</td>
</tr>
<tr>
<td>ocf_to_interestdebt</td>
<td>float</td>
<td>N</td>
<td>经营活动产生的现金流量净额/带息债务</td>
</tr>
<tr>
<td>ocf_to_netdebt</td>
<td>float</td>
<td>N</td>
<td>经营活动产生的现金流量净额/净债务</td>
</tr>
<tr>
<td>ebit_to_interest</td>
<td>float</td>
<td>N</td>
<td>已获利息倍数(EBIT/利息费用)</td>
</tr>
<tr>
<td>longdebt_to_workingcapital</td>
<td>float</td>
<td>N</td>
<td>长期债务与营运资金比率</td>
</tr>
<tr>
<td>ebitda_to_debt</td>
<td>float</td>
<td>N</td>
<td>息税折旧摊销前利润/负债合计</td>
</tr>
<tr>
<td>turn_days</td>
<td>float</td>
<td>Y</td>
<td>营业周期</td>
</tr>
<tr>
<td>roa_yearly</td>
<td>float</td>
<td>Y</td>
<td>年化总资产净利率</td>
</tr>
<tr>
<td>roa_dp</td>
<td>float</td>
<td>Y</td>
<td>总资产净利率(杜邦分析)</td>
</tr>
<tr>
<td>fixed_assets</td>
<td>float</td>
<td>Y</td>
<td>固定资产合计</td>
</tr>
<tr>
<td>profit_prefin_exp</td>
<td>float</td>
<td>N</td>
<td>扣除财务费用前营业利润</td>
</tr>
<tr>
<td>non_op_profit</td>
<td>float</td>
<td>N</td>
<td>非营业利润</td>
</tr>
<tr>
<td>op_to_ebt</td>
<td>float</td>
<td>N</td>
<td>营业利润／利润总额</td>
</tr>
<tr>
<td>nop_to_ebt</td>
<td>float</td>
<td>N</td>
<td>非营业利润／利润总额</td>
</tr>
<tr>
<td>ocf_to_profit</td>
<td>float</td>
<td>N</td>
<td>经营活动产生的现金流量净额／营业利润</td>
</tr>
<tr>
<td>cash_to_liqdebt</td>
<td>float</td>
<td>N</td>
<td>货币资金／流动负债</td>
</tr>
<tr>
<td>cash_to_liqdebt_withinterest</td>
<td>float</td>
<td>N</td>
<td>货币资金／带息流动负债</td>
</tr>
<tr>
<td>op_to_liqdebt</td>
<td>float</td>
<td>N</td>
<td>营业利润／流动负债</td>
</tr>
<tr>
<td>op_to_debt</td>
<td>float</td>
<td>N</td>
<td>营业利润／负债合计</td>
</tr>
<tr>
<td>roic_yearly</td>
<td>float</td>
<td>N</td>
<td>年化投入资本回报率</td>
</tr>
<tr>
<td>total_fa_trun</td>
<td>float</td>
<td>N</td>
<td>固定资产合计周转率</td>
</tr>
<tr>
<td>profit_to_op</td>
<td>float</td>
<td>Y</td>
<td>利润总额／营业收入</td>
</tr>
<tr>
<td>q_opincome</td>
<td>float</td>
<td>N</td>
<td>经营活动单季度净收益</td>
</tr>
<tr>
<td>q_investincome</td>
<td>float</td>
<td>N</td>
<td>价值变动单季度净收益</td>
</tr>
<tr>
<td>q_dtprofit</td>
<td>float</td>
<td>N</td>
<td>扣除非经常损益后的单季度净利润</td>
</tr>
<tr>
<td>q_eps</td>
<td>float</td>
<td>N</td>
<td>每股收益(单季度)</td>
</tr>
<tr>
<td>q_netprofit_margin</td>
<td>float</td>
<td>N</td>
<td>销售净利率(单季度)</td>
</tr>
<tr>
<td>q_gsprofit_margin</td>
<td>float</td>
<td>N</td>
<td>销售毛利率(单季度)</td>
</tr>
<tr>
<td>q_exp_to_sales</td>
<td>float</td>
<td>N</td>
<td>销售期间费用率(单季度)</td>
</tr>
<tr>
<td>q_profit_to_gr</td>
<td>float</td>
<td>N</td>
<td>净利润／营业总收入(单季度)</td>
</tr>
<tr>
<td>q_saleexp_to_gr</td>
<td>float</td>
<td>Y</td>
<td>销售费用／营业总收入 (单季度)</td>
</tr>
<tr>
<td>q_adminexp_to_gr</td>
<td>float</td>
<td>N</td>
<td>管理费用／营业总收入 (单季度)</td>
</tr>
<tr>
<td>q_finaexp_to_gr</td>
<td>float</td>
<td>N</td>
<td>财务费用／营业总收入 (单季度)</td>
</tr>
<tr>
<td>q_impair_to_gr_ttm</td>
<td>float</td>
<td>N</td>
<td>资产减值损失／营业总收入(单季度)</td>
</tr>
<tr>
<td>q_gc_to_gr</td>
<td>float</td>
<td>Y</td>
<td>营业总成本／营业总收入 (单季度)</td>
</tr>
<tr>
<td>q_op_to_gr</td>
<td>float</td>
<td>N</td>
<td>营业利润／营业总收入(单季度)</td>
</tr>
<tr>
<td>q_roe</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率(单季度)</td>
</tr>
<tr>
<td>q_dt_roe</td>
<td>float</td>
<td>Y</td>
<td>净资产单季度收益率(扣除非经常损益)</td>
</tr>
<tr>
<td>q_npta</td>
<td>float</td>
<td>Y</td>
<td>总资产净利润(单季度)</td>
</tr>
<tr>
<td>q_opincome_to_ebt</td>
<td>float</td>
<td>N</td>
<td>经营活动净收益／利润总额(单季度)</td>
</tr>
<tr>
<td>q_investincome_to_ebt</td>
<td>float</td>
<td>N</td>
<td>价值变动净收益／利润总额(单季度)</td>
</tr>
<tr>
<td>q_dtprofit_to_profit</td>
<td>float</td>
<td>N</td>
<td>扣除非经常损益后的净利润／净利润(单季度)</td>
</tr>
<tr>
<td>q_salescash_to_or</td>
<td>float</td>
<td>N</td>
<td>销售商品提供劳务收到的现金／营业收入(单季度)</td>
</tr>
<tr>
<td>q_ocf_to_sales</td>
<td>float</td>
<td>Y</td>
<td>经营活动产生的现金流量净额／营业收入(单季度)</td>
</tr>
<tr>
<td>q_ocf_to_or</td>
<td>float</td>
<td>N</td>
<td>经营活动产生的现金流量净额／经营活动净收益(单季度)</td>
</tr>
<tr>
<td>basic_eps_yoy</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益同比增长率(%)</td>
</tr>
<tr>
<td>dt_eps_yoy</td>
<td>float</td>
<td>Y</td>
<td>稀释每股收益同比增长率(%)</td>
</tr>
<tr>
<td>cfps_yoy</td>
<td>float</td>
<td>Y</td>
<td>每股经营活动产生的现金流量净额同比增长率(%)</td>
</tr>
<tr>
<td>op_yoy</td>
<td>float</td>
<td>Y</td>
<td>营业利润同比增长率(%)</td>
</tr>
<tr>
<td>ebt_yoy</td>
<td>float</td>
<td>Y</td>
<td>利润总额同比增长率(%)</td>
</tr>
<tr>
<td>netprofit_yoy</td>
<td>float</td>
<td>Y</td>
<td>归属母公司股东的净利润同比增长率(%)</td>
</tr>
<tr>
<td>dt_netprofit_yoy</td>
<td>float</td>
<td>Y</td>
<td>归属母公司股东的净利润-扣除非经常损益同比增长率(%)</td>
</tr>
<tr>
<td>ocf_yoy</td>
<td>float</td>
<td>Y</td>
<td>经营活动产生的现金流量净额同比增长率(%)</td>
</tr>
<tr>
<td>roe_yoy</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率(摊薄)同比增长率(%)</td>
</tr>
<tr>
<td>bps_yoy</td>
<td>float</td>
<td>Y</td>
<td>每股净资产相对年初增长率(%)</td>
</tr>
<tr>
<td>assets_yoy</td>
<td>float</td>
<td>Y</td>
<td>资产总计相对年初增长率(%)</td>
</tr>
<tr>
<td>eqt_yoy</td>
<td>float</td>
<td>Y</td>
<td>归属母公司的股东权益相对年初增长率(%)</td>
</tr>
<tr>
<td>tr_yoy</td>
<td>float</td>
<td>Y</td>
<td>营业总收入同比增长率(%)</td>
</tr>
<tr>
<td>or_yoy</td>
<td>float</td>
<td>Y</td>
<td>营业收入同比增长率(%)</td>
</tr>
<tr>
<td>q_gr_yoy</td>
<td>float</td>
<td>N</td>
<td>营业总收入同比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_gr_qoq</td>
<td>float</td>
<td>N</td>
<td>营业总收入环比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_sales_yoy</td>
<td>float</td>
<td>Y</td>
<td>营业收入同比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_sales_qoq</td>
<td>float</td>
<td>N</td>
<td>营业收入环比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_op_yoy</td>
<td>float</td>
<td>N</td>
<td>营业利润同比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_op_qoq</td>
<td>float</td>
<td>Y</td>
<td>营业利润环比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_profit_yoy</td>
<td>float</td>
<td>N</td>
<td>净利润同比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_profit_qoq</td>
<td>float</td>
<td>N</td>
<td>净利润环比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_netprofit_yoy</td>
<td>float</td>
<td>N</td>
<td>归属母公司股东的净利润同比增长率(%)(单季度)</td>
</tr>
<tr>
<td>q_netprofit_qoq</td>
<td>float</td>
<td>N</td>
<td>归属母公司股东的净利润环比增长率(%)(单季度)</td>
</tr>
<tr>
<td>equity_yoy</td>
<td>float</td>
<td>Y</td>
<td>净资产同比增长率</td>
</tr>
<tr>
<td>rd_exp</td>
<td>float</td>
<td>N</td>
<td>研发费用</td>
</tr>
<tr>
<td>update_flag</td>
<td>str</td>
<td>N</td>
<td>更新标识</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.fina_indicator(ts_code='600000.SH')

```

或者

```

df = pro.query('fina_indicator', ts_code='600000.SH', start_date='20170101', end_date='20180801')

```

数据样例

```
ts_code  ann_date  end_date   eps  dt_eps  total_revenue_ps  revenue_ps  \
0  600000.SH  20180830  20180630  0.95    0.95            2.8024      2.8024   
1  600000.SH  20180428  20180331  0.46    0.46            1.3501      1.3501   
2  600000.SH  20180428  20171231  1.84    1.84            5.7447      5.7447   
3  600000.SH  20180428  20171231  1.84    1.84            5.7447      5.7447   
4  600000.SH  20171028  20170930  1.45    1.45            4.2507      4.2507   
5  600000.SH  20171028  20170930  1.45    1.45            4.2507      4.2507   
6  600000.SH  20170830  20170630  0.97    0.97            2.9659      2.9659   
7  600000.SH  20170427  20170331  0.63    0.63            1.9595      1.9595   
8  600000.SH  20170427  20170331  0.63    0.63            1.9595      1.9595  

```
