# 财务审计意见

**文档ID**: 80
**原始链接**: https://tushare.pro/document/2?doc_id=80

---

## 财务审计意见

接口：fina_audit描述：获取上市公司定期财务审计意见数据权限：用户需要至少500积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(每个季度最后一天的日期,比如20171231表示年报)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>报告期</td>
</tr>
<tr>
<td>audit_result</td>
<td>str</td>
<td>审计结果</td>
</tr>
<tr>
<td>audit_fees</td>
<td>float</td>
<td>审计总费用（元）</td>
</tr>
<tr>
<td>audit_agency</td>
<td>str</td>
<td>会计事务所</td>
</tr>
<tr>
<td>audit_sign</td>
<td>str</td>
<td>签字会计师</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

df = pro.fina_audit(ts_code='600000.SH', start_date='20100101', end_date='20180808')

```

数据示例

```
      ts_code  ann_date  end_date        audit_result  audit_agency                audit_sign
0  600000.SH  20180428  20171231      标准无保留意见  普华永道中天会计师事务所      周章,张武
1  600000.SH  20170401  20161231      标准无保留意见  普华永道中天会计师事务所      周章,张武
2  600000.SH  20160407  20151231      标准无保留意见  普华永道中天会计师事务所      胡亮,张武
3  600000.SH  20150319  20141231      标准无保留意见  普华永道中天会计师事务所      胡亮,张武
4  600000.SH  20140320  20131231      标准无保留意见  普华永道中天会计师事务所      胡亮,周章
5  600000.SH  20130314  20121231      标准无保留意见  普华永道中天会计师事务所      胡亮,周章
6  600000.SH  20120316  20111231      标准无保留意见  普华永道中天会计师事务所      胡亮,周章
7  600000.SH  20110330  20101231      标准无保留意见    安永华明会计师事务所    严盛炜,周明骏
8  600000.SH  20100830  20100630      标准无保留意见    安永华明会计师事务所    严盛炜,周明骏
9  600000.SH  20100407  20091231      标准无保留意见    安永华明会计师事务所    严盛炜,周明骏
```
