# 融资融券交易明细

**文档ID**: 59
**原始链接**: https://tushare.pro/document/2?doc_id=59

---

## 融资融券交易明细

接口：margin_detail描述：获取沪深两市每日融资融券明细限量：单次请求最大返回6000行数据，可根据日期循环权限：2000积分可获得本接口权限，积分越高权限越大，具体参考权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD，下同）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>股票名称 （20190910后有数据）</td>
</tr>
<tr>
<td>rzye</td>
<td>float</td>
<td>融资余额(元)</td>
</tr>
<tr>
<td>rqye</td>
<td>float</td>
<td>融券余额(元)</td>
</tr>
<tr>
<td>rzmre</td>
<td>float</td>
<td>融资买入额(元)</td>
</tr>
<tr>
<td>rqyl</td>
<td>float</td>
<td>融券余量（股）</td>
</tr>
<tr>
<td>rzche</td>
<td>float</td>
<td>融资偿还额(元)</td>
</tr>
<tr>
<td>rqchl</td>
<td>float</td>
<td>融券偿还量(股)</td>
</tr>
<tr>
<td>rqmcl</td>
<td>float</td>
<td>融券卖出量(股,份,手)</td>
</tr>
<tr>
<td>rzrqye</td>
<td>float</td>
<td>融资融券余额(元)</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

df = pro.margin_detail(trade_date='20180802')

```

或者

```

df = pro.query('margin_detail', trade_date='20180802')

```

数据样例

```
    trade_date    ts_code          rzye        rqye        rzmre       rqyl  \
0     20180802  000001.SZ  4.430811e+09   8238210.0   78800436.0   921500.0   
1     20180802  000002.SZ  2.613071e+09  30772020.0  186176338.0  1439290.0   
2     20180802  000006.SZ  8.214685e+08   1008250.0   15199626.0   185000.0   
3     20180802  000009.SZ  1.318175e+09     74451.0    8010979.0    15674.0   
4     20180802  000012.SZ  6.422077e+08    190201.0    7831261.0    38347.0   
5     20180802  000022.SZ  1.891423e+08   1761368.0    8868547.0    99400.0   
6     20180802  000027.SZ  3.583209e+08    104157.0    4235209.0    21300.0   
7     20180802  000028.SZ  2.885056e+08    524656.0    4737219.0    12100.0   
8     20180802  000030.SZ  1.076096e+08    965944.0    2717503.0   200820.0   
9     20180802  000031.SZ  5.659868e+08     90675.0    2056441.0    15500.0   
10    20180802  000036.SZ  3.974383e+08    620420.0    5980093.0   110199.0   
11    20180802  000039.SZ  1.047953e+09   2519010.0   17651054.0   215300.0   
12    20180802  000043.SZ  3.496989e+08     14532.0    2299872.0     2100.0   
13    20180802  000046.SZ  7.221042e+08   2208480.0   17142811.0   344000.0   
14    20180802  000049.SZ  3.914922e+08   1795218.0   12595082.0    65783.0   
15    20180802  000050.SZ  1.884433e+09    517992.0   51120876.0    38200.0   
16    20180802  000059.SZ  7.077480e+08    587805.0   49392632.0    78900.0   
17    20180802  000060.SZ  1.425264e+09   2372025.0   21992232.0   520181.0   
18    20180802  000061.SZ  6.317999e+08    547716.0    5760238.0   105128.0   
19    20180802  000062.SZ  5.627777e+08    795577.0    3060551.0    39191.0   
20    20180802  000063.SZ  2.581872e+09   3873697.0  194982814.0   276101.0   

           rzche     rqchl      rqmcl        rzrqye  
0    147005397.0  544400.0   260000.0  4.439049e+09  
1    133408689.0  437600.0   516700.0  2.643843e+09  
2     16084617.0   90000.0      100.0  8.224767e+08  
3     11337406.0   80000.0     2000.0  1.318249e+09  
4      8260616.0       0.0    26700.0  6.423979e+08  
5      8464082.0   10000.0    19400.0  1.909037e+08  
6      2999201.0   21700.0        0.0  3.584250e+08  
7      4526179.0    4400.0        0.0  2.890302e+08  
8      1906548.0   14140.0   171700.0  1.085755e+08  
9      4193433.0   37600.0     7500.0  5.660775e+08  
10     5291427.0       0.0        0.0  3.980587e+08  
11    24101032.0    1700.0    33900.0  1.050472e+09  
12     2852687.0   17200.0        0.0  3.497134e+08  
13     8927796.0  147100.0    48600.0  7.243127e+08  
14    12113754.0    1800.0    12900.0  3.932874e+08  
15    59634348.0       0.0     8600.0  1.884951e+09  
16    52573324.0       0.0    69700.0  7.083358e+08  
17    19472310.0  365340.0   458531.0  1.427636e+09  
18     3299825.0    6000.0    46728.0  6.323476e+08  
19     9640216.0    7420.0    32296.0  5.635733e+08  
20   201355327.0   63900.0    10900.0  2.585746e+09 

```

说明

本报表基于证券公司报送的融资融券余额数据汇总生成，其中：本日融资余额(元)=前日融资余额＋本日融资买入-本日融资偿还额本日融券余量(股)=前日融券余量＋本日融券卖出量-本日融券买入量-本日现券偿还量本日融券余额(元)=本日融券余量×本日收盘价本日融资融券余额(元)=本日融资余额＋本日融券余额

单位说明：股（标的证券为股票）、份（标的证券为基金）、手（标的证券为债券）。

2014年9月22日起，“融资融券交易总量”数据包含调出标的证券名单的证券的融资融券余额。
