# 股票曾用名

**文档ID**: 100
**原始链接**: https://tushare.pro/document/2?doc_id=100

---

## 股票曾用名

接口：namechange描述：历史名称变更记录

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认输出</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>证券名称</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>Y</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>结束日期</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>change_reason</td>
<td>str</td>
<td>Y</td>
<td>变更原因</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.namechange(ts_code='600848.SH', fields='ts_code,name,start_date,end_date,change_reason')

```

数据样例

```
    ts_code    name    start_date   end_date      change_reason
0  600848.SH   上海临港   20151118      None         改名
1  600848.SH   自仪股份   20070514  20151117         撤销ST
2  600848.SH   ST自仪     20061026  20070513         完成股改
3  600848.SH   SST自仪   20061009  20061025        未股改加S
4  600848.SH   ST自仪     20010508  20061008         ST
5  600848.SH   自仪股份  19940324  20010507         其他
```
