# 股票收盘集合竞价数据

**文档ID**: 354
**原始链接**: https://tushare.pro/document/2?doc_id=354

---

## 股票收盘集合竞价数据

接口：stk_auction_c描述：股票收盘15:00集合竞价数据，每天盘后更新限量：单次请求最大返回10000行数据，可根据日期循环权限：开通了股票分钟权限后可获得本接口权限，具体参考权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(YYYYMMDD)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期(YYYYMMDD)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期(YYYYMMDD)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘集合竞价收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>收盘集合竞价开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>收盘集合竞价最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>收盘集合竞价最低价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>收盘集合竞价成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>收盘集合竞价成交额</td>
</tr>
<tr>
<td>vwap</td>
<td>float</td>
<td>Y</td>
<td>收盘集合竞价均价</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df=pro.stk_auction_c(trade_date='20241122')

```

数据样例

```
      ts_code     trade_date close  ...   vol        amount      vwap
0     603102.SH   20241122  36.16  ...    557900.0   20347168.0  36.471
1     600696.SH   20241122  13.91  ...   3600489.0   50550184.0  14.040
2     600769.SH   20241122  12.75  ...   7940892.0  102510940.0  12.909
3     601900.SH   20241122  14.91  ...   6348300.0   95537632.0  15.049
4     600502.SH   20241122   4.88  ...   9718900.0   47690748.0   4.907
...         ...        ...    ...  ...         ...          ...     ...
5719  300504.SZ   20241122  16.34  ...   2037000.0   33653784.0  16.521
5720  300535.SZ   20241122  14.45  ...    638735.0    9340342.0  14.623
5721  300588.SZ   20241122  15.39  ...   3232050.0   50313180.0  15.567
5722  300592.SZ   20241122  14.43  ...   9910880.0  143872140.0  14.517
5723  300657.SZ   20241122  21.13  ...  10916225.0  235013090.0  21.529

```
