# 股票技术面因子

**文档ID**: 296
**原始链接**: https://tushare.pro/document/2?doc_id=296

---

## 股票技术因子（量化因子）

接口：stk_factor描述：获取股票每日技术面因子数据，用于跟踪股票当前走势情况，数据由Tushare社区自产，覆盖全历史限量：单次最大10000条，可以循环或者分页提取积分：5000积分每分钟可以请求100次，8000积分以上每分钟500次，具体请参阅积分获取办法

```
注：
1、本接口的前复权行情是从最新一个交易日开始往前复权，是历史当日的数据快照数据不更新
2、pro_bar接口的前复权是动态复权，即以end_date参数开始往前复权，与本接口会存在不一致的可能
3、本接口技术指标都是基于前复权价格计算

```

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （yyyymmdd，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌额</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量 （手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额 （千元）</td>
</tr>
<tr>
<td>adj_factor</td>
<td>float</td>
<td>Y</td>
<td>复权因子</td>
</tr>
<tr>
<td>open_hfq</td>
<td>float</td>
<td>Y</td>
<td>开盘价后复权</td>
</tr>
<tr>
<td>open_qfq</td>
<td>float</td>
<td>Y</td>
<td>开盘价前复权</td>
</tr>
<tr>
<td>close_hfq</td>
<td>float</td>
<td>Y</td>
<td>收盘价后复权</td>
</tr>
<tr>
<td>close_qfq</td>
<td>float</td>
<td>Y</td>
<td>收盘价前复权</td>
</tr>
<tr>
<td>high_hfq</td>
<td>float</td>
<td>Y</td>
<td>最高价后复权</td>
</tr>
<tr>
<td>high_qfq</td>
<td>float</td>
<td>Y</td>
<td>最高价前复权</td>
</tr>
<tr>
<td>low_hfq</td>
<td>float</td>
<td>Y</td>
<td>最低价后复权</td>
</tr>
<tr>
<td>low_qfq</td>
<td>float</td>
<td>Y</td>
<td>最低价前复权</td>
</tr>
<tr>
<td>pre_close_hfq</td>
<td>float</td>
<td>Y</td>
<td>昨收价后复权</td>
</tr>
<tr>
<td>pre_close_qfq</td>
<td>float</td>
<td>Y</td>
<td>昨收价前复权</td>
</tr>
<tr>
<td>macd_dif</td>
<td>float</td>
<td>Y</td>
<td>MCAD_DIF (基于前复权价格计算，下同)</td>
</tr>
<tr>
<td>macd_dea</td>
<td>float</td>
<td>Y</td>
<td>MCAD_DEA</td>
</tr>
<tr>
<td>macd</td>
<td>float</td>
<td>Y</td>
<td>MCAD</td>
</tr>
<tr>
<td>kdj_k</td>
<td>float</td>
<td>Y</td>
<td>KDJ_K</td>
</tr>
<tr>
<td>kdj_d</td>
<td>float</td>
<td>Y</td>
<td>KDJ_D</td>
</tr>
<tr>
<td>kdj_j</td>
<td>float</td>
<td>Y</td>
<td>KDJ_J</td>
</tr>
<tr>
<td>rsi_6</td>
<td>float</td>
<td>Y</td>
<td>RSI_6</td>
</tr>
<tr>
<td>rsi_12</td>
<td>float</td>
<td>Y</td>
<td>RSI_12</td>
</tr>
<tr>
<td>rsi_24</td>
<td>float</td>
<td>Y</td>
<td>RSI_24</td>
</tr>
<tr>
<td>boll_upper</td>
<td>float</td>
<td>Y</td>
<td>BOLL_UPPER</td>
</tr>
<tr>
<td>boll_mid</td>
<td>float</td>
<td>Y</td>
<td>BOLL_MID</td>
</tr>
<tr>
<td>boll_lower</td>
<td>float</td>
<td>Y</td>
<td>BOLL_LOWER</td>
</tr>
<tr>
<td>cci</td>
<td>float</td>
<td>Y</td>
<td>CCI</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.stk_factor(ts_code='600000.SH', start_date='20220501', end_date='20220520', fields='ts_code,trade_date,macd,kdj_k,kdj_d,kdj_j')

```

数据样例

```
       ts_code trade_date   macd   kdj_k   kdj_d   kdj_j
0   600000.SH   20220520   0.027  72.966  64.718   89.46
1   600000.SH   20220519   0.015  63.615  60.594  69.656
2   600000.SH   20220518   0.023  67.645  59.084  84.766
3   600000.SH   20220517   0.025  68.134  54.804  94.794
4   600000.SH   20220516   0.014  60.309  48.139  84.649
5   600000.SH   20220513   0.006  55.328  42.054  81.877
6   600000.SH   20220512  -0.022  37.046  35.417  40.306
7   600000.SH   20220511  -0.027  33.948  34.602   32.64
8   600000.SH   20220510   -0.03  30.652  34.929  22.098
9   600000.SH   20220509  -0.029  28.029  37.067   9.952
10  600000.SH   20220506  -0.018  37.498  41.587  29.321
11  600000.SH   20220505  -0.004  48.139  43.631  57.155

```
