# 股票开盘集合竞价数据

**文档ID**: 353
**原始链接**: https://tushare.pro/document/2?doc_id=353

---

## 股票开盘集合竞价数据

接口：stk_auction_o描述：股票开盘9:30集合竞价数据，每天盘后更新限量：单次请求最大返回10000行数据，可根据日期循环权限：开通了股票分钟权限后可获得本接口权限，具体参考权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(YYYYMMDD)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期(YYYYMMDD)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期(YYYYMMDD)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>开盘集合竞价收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘集合竞价开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>开盘集合竞价最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>开盘集合竞价最低价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>开盘集合竞价成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>开盘集合竞价成交额</td>
</tr>
<tr>
<td>vwap</td>
<td>float</td>
<td>Y</td>
<td>开盘集合竞价均价</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df=pro.stk_auction_o(trade_date='20241122')

```

数据样例

```
      ts_code    trade_date  close  open  ...   low    vol        amount     vwap
0     600502.SH   20241122   5.00   5.00  ...   5.00   45400.0    227000.0   5.000
1     600662.SH   20241122   5.28   5.28  ...   5.28   26800.0    141504.0   5.280
2     601118.SH   20241122   5.63   5.63  ...   5.63  152200.0    856886.0   5.630
3     600938.SH   20241122  26.54  26.54  ...  26.54  340400.0   9034216.0  26.540
4     601900.SH   20241122  15.09  15.09  ...  15.09  287600.0   4339884.0  15.090
...         ...        ...    ...    ...  ...    ...       ...         ...     ...
5719  300504.SZ   20241122  16.80  16.97  ...  16.80   19000.0    320954.0  16.892
5720  300535.SZ   20241122  15.26  15.29  ...  15.26   22800.0    348343.0  15.278
5721  300588.SZ   20241122  15.58  15.60  ...  15.45  117400.0   1830260.0  15.590
5722  300592.SZ   20241122  14.27  14.34  ...  14.23  502600.0   7194406.0  14.314
5723  300657.SZ   20241122  21.73  21.88  ...  21.71  545100.0  11902781.0  21.836

```
