# 股票回购

**文档ID**: 124
**原始链接**: https://tushare.pro/document/2?doc_id=124

---

## 股票回购

接口：repurchase描述：获取上市公司回购股票数据积分：用户需要至少600积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期（任意填参数，如果都不填，单次默认返回2000条）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
</tbody></table>
以上日期格式为：YYYYMMDD，比如20181010

输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>截止日期</td>
</tr>
<tr>
<td>proc</td>
<td>str</td>
<td>Y</td>
<td>进度</td>
</tr>
<tr>
<td>exp_date</td>
<td>str</td>
<td>Y</td>
<td>过期日期</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>回购数量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>回购金额</td>
</tr>
<tr>
<td>high_limit</td>
<td>float</td>
<td>Y</td>
<td>回购最高价</td>
</tr>
<tr>
<td>low_limit</td>
<td>float</td>
<td>Y</td>
<td>回购最低价</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.repurchase(ann_date='', start_date='20180101', end_date='20180510')

#取某日
df = pro.repurchase(ann_date='20181010')

```

数据示例

```
  ts_code  ann_date  end_date    proc  exp_date         vol        amount  \
0   300451.SZ  20181010  20181008      完成      None     51900.0  4.498500e+05   
1   300396.SZ  20181010      None  股东大会通过  20191010         NaN  5.000000e+07   
2   000813.SZ  20181010  20180930      实施      None  15450767.0  1.243010e+08   
3   300451.SZ  20181010  20181008      完成      None      4500.0  3.708000e+04   
4   002334.SZ  20181010  20181009      实施      None   7749553.0  3.826948e+07   
5   600351.SH  20181010  20181010      实施      None   7035198.0  4.999188e+07   
6   002104.SZ  20181010  20180930      实施      None    569100.0  3.584390e+06   
7   603017.SH  20181010  20181009      实施      None   4418358.0  4.398425e+07   
8   002511.SZ  20181010      None  股东大会通过  20190410         NaN  2.000000e+08   
9   603180.SH  20181010  20181009      实施      None    315700.0  1.817800e+07   
10  002567.SZ  20181010  20180930      实施      None   1743273.0  7.815226e+06 


    high_limit  low_limit  
0       12.350      8.240  
1       21.000        NaN  
2        8.400      7.800  
3        8.240      8.240  
4        6.060      4.370  
5        7.490      6.850  
6        6.352      6.160  
7       10.600      9.080  
8        9.500        NaN  
9       59.860     55.060  
10       4.600      4.370  
```
