# 股票历史列表

**文档ID**: 262
**原始链接**: https://tushare.pro/document/2?doc_id=262

---

## 股票历史列表（历史每天股票列表）

接口：bak_basic描述：获取备用基础列表，数据从2016年开始限量：单次最大7000条，可以根据日期参数循环获取历史，正式权限需要5000积分。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>industry</td>
<td>str</td>
<td>Y</td>
<td>行业</td>
</tr>
<tr>
<td>area</td>
<td>str</td>
<td>Y</td>
<td>地域</td>
</tr>
<tr>
<td>pe</td>
<td>float</td>
<td>Y</td>
<td>市盈率（动）</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股本（亿）</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本（亿）</td>
</tr>
<tr>
<td>total_assets</td>
<td>float</td>
<td>Y</td>
<td>总资产（亿）</td>
</tr>
<tr>
<td>liquid_assets</td>
<td>float</td>
<td>Y</td>
<td>流动资产（亿）</td>
</tr>
<tr>
<td>fixed_assets</td>
<td>float</td>
<td>Y</td>
<td>固定资产（亿）</td>
</tr>
<tr>
<td>reserved</td>
<td>float</td>
<td>Y</td>
<td>公积金</td>
</tr>
<tr>
<td>reserved_pershare</td>
<td>float</td>
<td>Y</td>
<td>每股公积金</td>
</tr>
<tr>
<td>eps</td>
<td>float</td>
<td>Y</td>
<td>每股收益</td>
</tr>
<tr>
<td>bvps</td>
<td>float</td>
<td>Y</td>
<td>每股净资产</td>
</tr>
<tr>
<td>pb</td>
<td>float</td>
<td>Y</td>
<td>市净率</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市日期</td>
</tr>
<tr>
<td>undp</td>
<td>float</td>
<td>Y</td>
<td>未分配利润</td>
</tr>
<tr>
<td>per_undp</td>
<td>float</td>
<td>Y</td>
<td>每股未分配利润</td>
</tr>
<tr>
<td>rev_yoy</td>
<td>float</td>
<td>Y</td>
<td>收入同比（%）</td>
</tr>
<tr>
<td>profit_yoy</td>
<td>float</td>
<td>Y</td>
<td>利润同比（%）</td>
</tr>
<tr>
<td>gpr</td>
<td>float</td>
<td>Y</td>
<td>毛利率（%）</td>
</tr>
<tr>
<td>npr</td>
<td>float</td>
<td>Y</td>
<td>净利润率（%）</td>
</tr>
<tr>
<td>holder_num</td>
<td>int</td>
<td>Y</td>
<td>股东人数</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.bak_basic(trade_date='20211012', fields='trade_date,ts_code,name,industry,pe')

```

数据样例

```
 trade_date    ts_code  name industry       pe
0      20211012  300605.SZ  恒锋信息     软件服务  56.4400
1      20211012  301017.SZ  漱玉平民     医药商业  58.7600
2      20211012  300755.SZ  华致酒行     其他商业  23.0000
3      20211012  300255.SZ  常山药业     生物制药  24.9900
4      20211012  688378.SH   奥来德     专用机械  24.9600
...         ...        ...   ...      ...      ...
4529   20211012  688257.SH  新锐股份     机械基件   0.0000
4530   20211012  688255.SH   凯尔达     机械基件   0.0000
4531   20211012  688211.SH  中科微至     专用机械   0.0000
4532   20211012  605567.SH  春雪食品       食品   0.0000
4533   20211012  605566.SH  福莱蒽特     染料涂料   0.0000

```
