# 股票列表

**文档ID**: 25
**原始链接**: https://tushare.pro/document/2?doc_id=25

---

## 基础信息

接口：stock_basic，可以通过数据工具调试和查看数据描述：获取基础信息数据，包括股票代码、名称、上市日期、退市日期等权限：2000积分起。此接口是基础信息，调取一次就可以拉取完，建议保存倒本地存储后使用

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>名称</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>N</td>
<td>市场类别 （主板/创业板/科创板/CDR/北交所）</td>
</tr>
<tr>
<td>list_status</td>
<td>str</td>
<td>N</td>
<td>上市状态 L上市 D退市 P暂停上市，默认是L</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所 SSE上交所 SZSE深交所 BSE北交所</td>
</tr>
<tr>
<td>is_hs</td>
<td>str</td>
<td>N</td>
<td>是否沪深港通标的，N否 H沪股通 S深股通</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>symbol</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>area</td>
<td>str</td>
<td>Y</td>
<td>地域</td>
</tr>
<tr>
<td>industry</td>
<td>str</td>
<td>Y</td>
<td>所属行业</td>
</tr>
<tr>
<td>fullname</td>
<td>str</td>
<td>N</td>
<td>股票全称</td>
</tr>
<tr>
<td>enname</td>
<td>str</td>
<td>N</td>
<td>英文全称</td>
</tr>
<tr>
<td>cnspell</td>
<td>str</td>
<td>Y</td>
<td>拼音缩写</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>Y</td>
<td>市场类型（主板/创业板/科创板/CDR）</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所代码</td>
</tr>
<tr>
<td>curr_type</td>
<td>str</td>
<td>N</td>
<td>交易货币</td>
</tr>
<tr>
<td>list_status</td>
<td>str</td>
<td>N</td>
<td>上市状态 L上市 D退市 P暂停上市</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市日期</td>
</tr>
<tr>
<td>delist_date</td>
<td>str</td>
<td>N</td>
<td>退市日期</td>
</tr>
<tr>
<td>is_hs</td>
<td>str</td>
<td>N</td>
<td>是否沪深港通标的，N否 H沪股通 S深股通</td>
</tr>
<tr>
<td>act_name</td>
<td>str</td>
<td>Y</td>
<td>实控人名称</td>
</tr>
<tr>
<td>act_ent_type</td>
<td>str</td>
<td>Y</td>
<td>实控人企业性质</td>
</tr>
</tbody></table>
说明：旧版上的PE/PB/股本等字段，请在行情接口“每日指标”中获取。

接口示例

```

pro = ts.pro_api()

#查询当前所有正常上市交易的股票列表

data = pro.stock_basic(exchange='', list_status='L', fields='ts_code,symbol,name,area,industry,list_date')

```

```

#查询当前所有正常上市交易的股票列表

data = pro.query('stock_basic', exchange='', list_status='L', fields='ts_code,symbol,name,area,industry,list_date')

```

数据样例

```
    ts_code     symbol     name     area industry    list_date
0     000001.SZ  000001  平安银行   深圳       银行  19910403
1     000002.SZ  000002   万科A   深圳     全国地产  19910129
2     000004.SZ  000004  国农科技   深圳     生物制药  19910114
3     000005.SZ  000005  世纪星源   深圳     房产服务  19901210
4     000006.SZ  000006  深振业A   深圳     区域地产  19920427
5     000007.SZ  000007   全新好   深圳     酒店餐饮  19920413
6     000008.SZ  000008  神州高铁   北京     运输设备  19920507
7     000009.SZ  000009  中国宝安   深圳      综合类  19910625
8     000010.SZ  000010  美丽生态   深圳     建筑施工  19951027
9     000011.SZ  000011  深物业A   深圳     区域地产  19920330
10    000012.SZ  000012   南玻A   深圳       玻璃  19920228
11    000014.SZ  000014  沙河股份   深圳     全国地产  19920602
12    000016.SZ  000016  深康佳A   深圳     家用电器  19920327
13    000017.SZ  000017  深中华A   深圳     文教休闲  19920331
14    000018.SZ  000018  神州长城   深圳     装修装饰  19920616
15    000019.SZ  000019  深深宝A   深圳      软饮料  19921012
16    000020.SZ  000020  深华发A   深圳      元器件  19920428
17    000021.SZ  000021   深科技   深圳     电脑设备  19940202
18    000022.SZ  000022  深赤湾A   深圳       港口  19930505
19    000023.SZ  000023  深天地A   深圳     其他建材  19930429
20    000025.SZ  000025   特力A   深圳     汽车服务  19930621

```
